/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePinnedChannelMessages;
import telegram4j.tl.UpdatePinnedMessagesFields;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePinnedChannelMessages
implements UpdatePinnedChannelMessages {
    private final int identifier;
    private final int flags;
    private final boolean pinned;
    private final long channelId;
    private final List<Integer> messages;
    private final int pts;
    private final int ptsCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdatePinnedChannelMessages(long channelId, int pts, int ptsCount) {
        this.channelId = channelId;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.messages = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedChannelMessages(Builder builder) {
        this.channelId = builder.channelId;
        this.messages = ImmutableUpdatePinnedChannelMessages.createUnmodifiableList(true, builder.messages);
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pinnedIsSet()) {
            this.initShim.pinned(builder.pinned);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedChannelMessages(int identifier, int flags, boolean pinned, long channelId, List<Integer> messages, int pts, int ptsCount) {
        this.identifier = identifier;
        this.flags = flags;
        this.pinned = pinned;
        this.channelId = channelId;
        this.messages = messages;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdatePinnedChannelMessages.super.identifier();
    }

    private int flagsInitialize() {
        return UpdatePinnedChannelMessages.super.flags();
    }

    private boolean pinnedInitialize() {
        return UpdatePinnedChannelMessages.super.pinned();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinned() : this.pinned;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public List<Integer> messages() {
        return this.messages;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdatePinnedChannelMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(value, this.flags, this.pinned, this.channelId, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, value, this.pinned, this.channelId, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, value, this.channelId, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, this.pinned, value, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withMessages(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableUpdatePinnedChannelMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, this.pinned, this.channelId, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withMessages(Iterable<Integer> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableUpdatePinnedChannelMessages.createUnmodifiableList(false, ImmutableUpdatePinnedChannelMessages.createSafeList(elements, true, false));
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, this.pinned, this.channelId, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, this.pinned, this.channelId, this.messages, value, this.ptsCount);
    }

    public final ImmutableUpdatePinnedChannelMessages withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdatePinnedChannelMessages(this.identifier, this.flags, this.pinned, this.channelId, this.messages, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePinnedChannelMessages && this.equalTo(0, (ImmutableUpdatePinnedChannelMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePinnedChannelMessages another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pinned == another.pinned && this.channelId == another.channelId && this.messages.equals(another.messages) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdatePinnedChannelMessages{identifier=" + this.identifier + ", flags=" + this.flags + ", pinned=" + this.pinned + ", channelId=" + this.channelId + ", messages=" + this.messages + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdatePinnedChannelMessages of(long channelId, int pts, int ptsCount) {
        return new ImmutableUpdatePinnedChannelMessages(channelId, pts, ptsCount);
    }

    public static ImmutableUpdatePinnedChannelMessages copyOf(UpdatePinnedChannelMessages instance) {
        if (instance instanceof ImmutableUpdatePinnedChannelMessages) {
            return (ImmutableUpdatePinnedChannelMessages)instance;
        }
        return ImmutableUpdatePinnedChannelMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_PTS = 2L;
        private static final long INIT_BIT_PTS_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PINNED = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pinned;
        private long channelId;
        private List<Integer> messages = new ArrayList<Integer>();
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdatePinnedChannelMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdatePinnedMessagesFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePinnedChannelMessages) {
                instance = (UpdatePinnedChannelMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 0x10L;
                }
                this.channelId(instance.channelId());
                if ((bits & 0x20L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 0x20L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 8L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 0x20L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdatePinnedMessagesFields) {
                instance = (UpdatePinnedMessagesFields)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.optBits |= 4L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMessage(int element) {
            this.messages.add(element);
            return this;
        }

        public final Builder addMessages(int ... elements) {
            for (int element : elements) {
                this.messages.add(element);
            }
            return this;
        }

        public final Builder messages(Iterable<Integer> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdatePinnedChannelMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePinnedChannelMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pinnedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdatePinnedChannelMessages, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pinnedBuildStage = 0;
        private boolean pinned;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdatePinnedChannelMessages.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdatePinnedChannelMessages.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pinned() {
            if (this.pinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinnedBuildStage == 0) {
                this.pinnedBuildStage = (byte)-1;
                this.pinned = ImmutableUpdatePinnedChannelMessages.this.pinnedInitialize();
                this.pinnedBuildStage = 1;
            }
            return this.pinned;
        }

        void pinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pinnedBuildStage == -1) {
                attributes.add("pinned");
            }
            return "Cannot build UpdatePinnedChannelMessages, attribute initializers form cycle " + attributes;
        }
    }
}

