/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DialogPeer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePinnedDialogs;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePinnedDialogs
implements UpdatePinnedDialogs {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer folderId;
    @Nullable
    private final List<DialogPeer> order;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableUpdatePinnedDialogs INSTANCE = ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs());

    private ImmutableUpdatePinnedDialogs() {
        this.folderId = null;
        this.order = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedDialogs(Builder builder) {
        this.folderId = builder.folderId;
        List<DialogPeer> list = this.order = builder.order == null ? null : ImmutableUpdatePinnedDialogs.createUnmodifiableList(true, builder.order);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdatePinnedDialogs(int identifier, int flags, @Nullable Integer folderId, @Nullable List<DialogPeer> order) {
        this.identifier = identifier;
        this.flags = flags;
        this.folderId = folderId;
        this.order = order;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdatePinnedDialogs.super.identifier();
    }

    private int flagsInitialize() {
        return UpdatePinnedDialogs.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    @Nullable
    public List<DialogPeer> order() {
        return this.order;
    }

    public final ImmutableUpdatePinnedDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(value, this.flags, this.folderId, this.order));
    }

    public final ImmutableUpdatePinnedDialogs withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this.identifier, value, this.folderId, this.order));
    }

    public final ImmutableUpdatePinnedDialogs withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this.identifier, this.flags, value, this.order));
    }

    public final ImmutableUpdatePinnedDialogs withOrder(DialogPeer ... elements) {
        if (elements == null) {
            return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this.identifier, this.flags, this.folderId, null));
        }
        List<DialogPeer> newValue = Arrays.asList(elements) == null ? null : ImmutableUpdatePinnedDialogs.createUnmodifiableList(false, ImmutableUpdatePinnedDialogs.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this.identifier, this.flags, this.folderId, newValue));
    }

    public final ImmutableUpdatePinnedDialogs withOrder(@Nullable Iterable<? extends DialogPeer> elements) {
        if (this.order == elements) {
            return this;
        }
        List<DialogPeer> newValue = elements == null ? null : ImmutableUpdatePinnedDialogs.createUnmodifiableList(false, ImmutableUpdatePinnedDialogs.createSafeList(elements, true, false));
        return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this.identifier, this.flags, this.folderId, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePinnedDialogs && this.equalTo(0, (ImmutableUpdatePinnedDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePinnedDialogs another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.folderId, another.folderId) && Objects.equals(this.order, another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + Objects.hashCode(this.order);
        return h;
    }

    public String toString() {
        return "UpdatePinnedDialogs{identifier=" + this.identifier + ", flags=" + this.flags + ", folderId=" + this.folderId + ", order=" + this.order + "}";
    }

    public static ImmutableUpdatePinnedDialogs of() {
        return INSTANCE;
    }

    private static ImmutableUpdatePinnedDialogs validate(ImmutableUpdatePinnedDialogs instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdatePinnedDialogs copyOf(UpdatePinnedDialogs instance) {
        if (instance instanceof ImmutableUpdatePinnedDialogs) {
            return (ImmutableUpdatePinnedDialogs)instance;
        }
        return ImmutableUpdatePinnedDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer folderId;
        private List<DialogPeer> order = null;

        private Builder() {
        }

        public final Builder from(UpdatePinnedDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePinnedDialogs) {
                List<DialogPeer> orderValue;
                Integer folderIdValue;
                instance = (UpdatePinnedDialogs)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((folderIdValue = instance.folderId()) != null) {
                    this.folderId(folderIdValue);
                }
                if ((orderValue = instance.order()) != null) {
                    this.addAllOrder(orderValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder addOrder(DialogPeer element) {
            if (this.order == null) {
                this.order = new ArrayList<DialogPeer>();
            }
            this.order.add(Objects.requireNonNull(element, "order element"));
            return this;
        }

        public final Builder addOrder(DialogPeer ... elements) {
            if (this.order == null) {
                this.order = new ArrayList<DialogPeer>();
            }
            for (DialogPeer element : elements) {
                this.order.add(Objects.requireNonNull(element, "order element"));
            }
            return this;
        }

        public final Builder order(@Nullable Iterable<? extends DialogPeer> elements) {
            if (elements == null) {
                this.order = null;
                return this;
            }
            this.order = new ArrayList<DialogPeer>();
            return this.addAllOrder(elements);
        }

        public final Builder addAllOrder(Iterable<? extends DialogPeer> elements) {
            Objects.requireNonNull(elements, "order element");
            if (this.order == null) {
                this.order = new ArrayList<DialogPeer>();
            }
            for (DialogPeer dialogPeer : elements) {
                this.order.add(Objects.requireNonNull(dialogPeer, "order element"));
            }
            return this;
        }

        public ImmutableUpdatePinnedDialogs build() {
            return ImmutableUpdatePinnedDialogs.validate(new ImmutableUpdatePinnedDialogs(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdatePinnedDialogs.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdatePinnedDialogs.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdatePinnedDialogs, attribute initializers form cycle " + attributes;
        }
    }
}

