/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PrivacyKey;
import telegram4j.tl.PrivacyRule;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePrivacy;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePrivacy
implements UpdatePrivacy {
    private final int identifier;
    private final PrivacyKey key;
    private final List<PrivacyRule> rules;

    private ImmutableUpdatePrivacy(PrivacyKey key) {
        this.key = Objects.requireNonNull(key, "key");
        this.rules = Collections.emptyList();
        this.identifier = UpdatePrivacy.super.identifier();
    }

    private ImmutableUpdatePrivacy(Builder builder) {
        this.key = builder.key;
        this.rules = ImmutableUpdatePrivacy.createUnmodifiableList(true, builder.rules);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePrivacy.super.identifier();
    }

    private ImmutableUpdatePrivacy(int identifier, PrivacyKey key, List<PrivacyRule> rules) {
        this.identifier = identifier;
        this.key = key;
        this.rules = rules;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public PrivacyKey key() {
        return this.key;
    }

    @Override
    public List<PrivacyRule> rules() {
        return this.rules;
    }

    public final ImmutableUpdatePrivacy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePrivacy(value, this.key, this.rules);
    }

    public final ImmutableUpdatePrivacy withKey(PrivacyKey value) {
        PrivacyKey newValue = Objects.requireNonNull(value, "key");
        if (this.key == newValue) {
            return this;
        }
        return new ImmutableUpdatePrivacy(this.identifier, newValue, this.rules);
    }

    public final ImmutableUpdatePrivacy withRules(PrivacyRule ... elements) {
        List<PrivacyRule> newValue = ImmutableUpdatePrivacy.createUnmodifiableList(false, ImmutableUpdatePrivacy.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdatePrivacy(this.identifier, this.key, newValue);
    }

    public final ImmutableUpdatePrivacy withRules(Iterable<? extends PrivacyRule> elements) {
        if (this.rules == elements) {
            return this;
        }
        List<PrivacyRule> newValue = ImmutableUpdatePrivacy.createUnmodifiableList(false, ImmutableUpdatePrivacy.createSafeList(elements, true, false));
        return new ImmutableUpdatePrivacy(this.identifier, this.key, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePrivacy && this.equalTo(0, (ImmutableUpdatePrivacy)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePrivacy another) {
        return this.identifier == another.identifier && this.key.equals((Object)another.key) && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePrivacy{identifier=" + this.identifier + ", key=" + this.key + ", rules=" + this.rules + "}";
    }

    public static ImmutableUpdatePrivacy of(PrivacyKey key) {
        return new ImmutableUpdatePrivacy(key);
    }

    public static ImmutableUpdatePrivacy copyOf(UpdatePrivacy instance) {
        if (instance instanceof ImmutableUpdatePrivacy) {
            return (ImmutableUpdatePrivacy)instance;
        }
        return ImmutableUpdatePrivacy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private PrivacyKey key;
        private List<PrivacyRule> rules = new ArrayList<PrivacyRule>();

        private Builder() {
        }

        public final Builder from(UpdatePrivacy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePrivacy) {
                instance = (UpdatePrivacy)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllRules(instance.rules());
                this.key(instance.key());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder key(PrivacyKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRule(PrivacyRule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder addRules(PrivacyRule ... elements) {
            for (PrivacyRule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends PrivacyRule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends PrivacyRule> elements) {
            for (PrivacyRule privacyRule : elements) {
                this.rules.add(Objects.requireNonNull(privacyRule, "rules element"));
            }
            return this;
        }

        public ImmutableUpdatePrivacy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePrivacy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build UpdatePrivacy, some of required attributes are not set " + attributes;
        }
    }
}

