/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadChannelDiscussionInbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadChannelDiscussionInbox
implements UpdateReadChannelDiscussionInbox {
    private final int identifier;
    private final int flags;
    private final long channelId;
    private final int topMsgId;
    private final int readMaxId;
    @Nullable
    private final Long broadcastId;
    @Nullable
    private final Integer broadcastPost;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateReadChannelDiscussionInbox(long channelId, int topMsgId, int readMaxId) {
        this.channelId = channelId;
        this.topMsgId = topMsgId;
        this.readMaxId = readMaxId;
        this.broadcastId = null;
        this.broadcastPost = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadChannelDiscussionInbox(Builder builder) {
        this.channelId = builder.channelId;
        this.topMsgId = builder.topMsgId;
        this.readMaxId = builder.readMaxId;
        this.broadcastId = builder.broadcastId;
        this.broadcastPost = builder.broadcastPost;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadChannelDiscussionInbox(int identifier, int flags, long channelId, int topMsgId, int readMaxId, @Nullable Long broadcastId, @Nullable Integer broadcastPost) {
        this.identifier = identifier;
        this.flags = flags;
        this.channelId = channelId;
        this.topMsgId = topMsgId;
        this.readMaxId = readMaxId;
        this.broadcastId = broadcastId;
        this.broadcastPost = broadcastPost;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateReadChannelDiscussionInbox.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateReadChannelDiscussionInbox.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int topMsgId() {
        return this.topMsgId;
    }

    @Override
    public int readMaxId() {
        return this.readMaxId;
    }

    @Override
    @Nullable
    public Long broadcastId() {
        return this.broadcastId;
    }

    @Override
    @Nullable
    public Integer broadcastPost() {
        return this.broadcastPost;
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(value, this.flags, this.channelId, this.topMsgId, this.readMaxId, this.broadcastId, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, value, this.channelId, this.topMsgId, this.readMaxId, this.broadcastId, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, this.flags, value, this.topMsgId, this.readMaxId, this.broadcastId, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withTopMsgId(int value) {
        if (this.topMsgId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, this.flags, this.channelId, value, this.readMaxId, this.broadcastId, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withReadMaxId(int value) {
        if (this.readMaxId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, this.flags, this.channelId, this.topMsgId, value, this.broadcastId, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withBroadcastId(@Nullable Long value) {
        if (Objects.equals(this.broadcastId, value)) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, this.flags, this.channelId, this.topMsgId, this.readMaxId, value, this.broadcastPost);
    }

    public final ImmutableUpdateReadChannelDiscussionInbox withBroadcastPost(@Nullable Integer value) {
        if (Objects.equals(this.broadcastPost, value)) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionInbox(this.identifier, this.flags, this.channelId, this.topMsgId, this.readMaxId, this.broadcastId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadChannelDiscussionInbox && this.equalTo(0, (ImmutableUpdateReadChannelDiscussionInbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadChannelDiscussionInbox another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channelId == another.channelId && this.topMsgId == another.topMsgId && this.readMaxId == another.readMaxId && Objects.equals(this.broadcastId, another.broadcastId) && Objects.equals(this.broadcastPost, another.broadcastPost);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.topMsgId;
        h += (h << 5) + this.readMaxId;
        h += (h << 5) + Objects.hashCode(this.broadcastId);
        h += (h << 5) + Objects.hashCode(this.broadcastPost);
        return h;
    }

    public String toString() {
        return "UpdateReadChannelDiscussionInbox{identifier=" + this.identifier + ", flags=" + this.flags + ", channelId=" + this.channelId + ", topMsgId=" + this.topMsgId + ", readMaxId=" + this.readMaxId + ", broadcastId=" + this.broadcastId + ", broadcastPost=" + this.broadcastPost + "}";
    }

    public static ImmutableUpdateReadChannelDiscussionInbox of(long channelId, int topMsgId, int readMaxId) {
        return new ImmutableUpdateReadChannelDiscussionInbox(channelId, topMsgId, readMaxId);
    }

    public static ImmutableUpdateReadChannelDiscussionInbox copyOf(UpdateReadChannelDiscussionInbox instance) {
        if (instance instanceof ImmutableUpdateReadChannelDiscussionInbox) {
            return (ImmutableUpdateReadChannelDiscussionInbox)instance;
        }
        return ImmutableUpdateReadChannelDiscussionInbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TOP_MSG_ID = 2L;
        private static final long INIT_BIT_READ_MAX_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private long channelId;
        private int topMsgId;
        private int readMaxId;
        private Long broadcastId;
        private Integer broadcastPost;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateReadChannelDiscussionInbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateReadChannelDiscussionInbox) {
                Integer broadcastPostValue;
                instance = (UpdateReadChannelDiscussionInbox)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((broadcastPostValue = instance.broadcastPost()) != null) {
                    this.broadcastPost(broadcastPostValue);
                }
                this.readMaxId(instance.readMaxId());
                Long broadcastIdValue = instance.broadcastId();
                if (broadcastIdValue != null) {
                    this.broadcastId(broadcastIdValue);
                }
                this.flags(instance.flags());
                this.topMsgId(instance.topMsgId());
                this.channelId(instance.channelId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topMsgId(int topMsgId) {
            this.topMsgId = topMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder readMaxId(int readMaxId) {
            this.readMaxId = readMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder broadcastId(@Nullable Long broadcastId) {
            this.broadcastId = broadcastId;
            return this;
        }

        public final Builder broadcastPost(@Nullable Integer broadcastPost) {
            this.broadcastPost = broadcastPost;
            return this;
        }

        public ImmutableUpdateReadChannelDiscussionInbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadChannelDiscussionInbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("topMsgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readMaxId");
            }
            return "Cannot build UpdateReadChannelDiscussionInbox, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateReadChannelDiscussionInbox.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateReadChannelDiscussionInbox.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateReadChannelDiscussionInbox, attribute initializers form cycle " + attributes;
        }
    }
}

