/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadChannelDiscussionOutbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadChannelDiscussionOutbox
implements UpdateReadChannelDiscussionOutbox {
    private final int identifier;
    private final long channelId;
    private final int topMsgId;
    private final int readMaxId;

    private ImmutableUpdateReadChannelDiscussionOutbox(long channelId, int topMsgId, int readMaxId) {
        this.channelId = channelId;
        this.topMsgId = topMsgId;
        this.readMaxId = readMaxId;
        this.identifier = UpdateReadChannelDiscussionOutbox.super.identifier();
    }

    private ImmutableUpdateReadChannelDiscussionOutbox(Builder builder) {
        this.channelId = builder.channelId;
        this.topMsgId = builder.topMsgId;
        this.readMaxId = builder.readMaxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateReadChannelDiscussionOutbox.super.identifier();
    }

    private ImmutableUpdateReadChannelDiscussionOutbox(int identifier, long channelId, int topMsgId, int readMaxId) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.topMsgId = topMsgId;
        this.readMaxId = readMaxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int topMsgId() {
        return this.topMsgId;
    }

    @Override
    public int readMaxId() {
        return this.readMaxId;
    }

    public final ImmutableUpdateReadChannelDiscussionOutbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionOutbox(value, this.channelId, this.topMsgId, this.readMaxId);
    }

    public final ImmutableUpdateReadChannelDiscussionOutbox withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionOutbox(this.identifier, value, this.topMsgId, this.readMaxId);
    }

    public final ImmutableUpdateReadChannelDiscussionOutbox withTopMsgId(int value) {
        if (this.topMsgId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionOutbox(this.identifier, this.channelId, value, this.readMaxId);
    }

    public final ImmutableUpdateReadChannelDiscussionOutbox withReadMaxId(int value) {
        if (this.readMaxId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelDiscussionOutbox(this.identifier, this.channelId, this.topMsgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadChannelDiscussionOutbox && this.equalTo(0, (ImmutableUpdateReadChannelDiscussionOutbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadChannelDiscussionOutbox another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.topMsgId == another.topMsgId && this.readMaxId == another.readMaxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.topMsgId;
        h += (h << 5) + this.readMaxId;
        return h;
    }

    public String toString() {
        return "UpdateReadChannelDiscussionOutbox{identifier=" + this.identifier + ", channelId=" + this.channelId + ", topMsgId=" + this.topMsgId + ", readMaxId=" + this.readMaxId + "}";
    }

    public static ImmutableUpdateReadChannelDiscussionOutbox of(long channelId, int topMsgId, int readMaxId) {
        return new ImmutableUpdateReadChannelDiscussionOutbox(channelId, topMsgId, readMaxId);
    }

    public static ImmutableUpdateReadChannelDiscussionOutbox copyOf(UpdateReadChannelDiscussionOutbox instance) {
        if (instance instanceof ImmutableUpdateReadChannelDiscussionOutbox) {
            return (ImmutableUpdateReadChannelDiscussionOutbox)instance;
        }
        return ImmutableUpdateReadChannelDiscussionOutbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TOP_MSG_ID = 2L;
        private static final long INIT_BIT_READ_MAX_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long channelId;
        private int topMsgId;
        private int readMaxId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateReadChannelDiscussionOutbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateReadChannelDiscussionOutbox) {
                instance = (UpdateReadChannelDiscussionOutbox)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.topMsgId(instance.topMsgId());
                this.readMaxId(instance.readMaxId());
                this.channelId(instance.channelId());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topMsgId(int topMsgId) {
            this.topMsgId = topMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder readMaxId(int readMaxId) {
            this.readMaxId = readMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateReadChannelDiscussionOutbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadChannelDiscussionOutbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("topMsgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readMaxId");
            }
            return "Cannot build UpdateReadChannelDiscussionOutbox, some of required attributes are not set " + attributes;
        }
    }
}

