/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadChannelInbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadChannelInbox
implements UpdateReadChannelInbox {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer folderId;
    private final long channelId;
    private final int maxId;
    private final int stillUnreadCount;
    private final int pts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateReadChannelInbox(long channelId, int maxId, int stillUnreadCount, int pts) {
        this.channelId = channelId;
        this.maxId = maxId;
        this.stillUnreadCount = stillUnreadCount;
        this.pts = pts;
        this.folderId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadChannelInbox(Builder builder) {
        this.folderId = builder.folderId;
        this.channelId = builder.channelId;
        this.maxId = builder.maxId;
        this.stillUnreadCount = builder.stillUnreadCount;
        this.pts = builder.pts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadChannelInbox(int identifier, int flags, @Nullable Integer folderId, long channelId, int maxId, int stillUnreadCount, int pts) {
        this.identifier = identifier;
        this.flags = flags;
        this.folderId = folderId;
        this.channelId = channelId;
        this.maxId = maxId;
        this.stillUnreadCount = stillUnreadCount;
        this.pts = pts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateReadChannelInbox.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateReadChannelInbox.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int stillUnreadCount() {
        return this.stillUnreadCount;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    public final ImmutableUpdateReadChannelInbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(value, this.flags, this.folderId, this.channelId, this.maxId, this.stillUnreadCount, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, value, this.folderId, this.channelId, this.maxId, this.stillUnreadCount, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, this.flags, value, this.channelId, this.maxId, this.stillUnreadCount, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, this.flags, this.folderId, value, this.maxId, this.stillUnreadCount, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, this.flags, this.folderId, this.channelId, value, this.stillUnreadCount, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withStillUnreadCount(int value) {
        if (this.stillUnreadCount == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, this.flags, this.folderId, this.channelId, this.maxId, value, this.pts);
    }

    public final ImmutableUpdateReadChannelInbox withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelInbox(this.identifier, this.flags, this.folderId, this.channelId, this.maxId, this.stillUnreadCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadChannelInbox && this.equalTo(0, (ImmutableUpdateReadChannelInbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadChannelInbox another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.folderId, another.folderId) && this.channelId == another.channelId && this.maxId == another.maxId && this.stillUnreadCount == another.stillUnreadCount && this.pts == another.pts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.stillUnreadCount;
        h += (h << 5) + this.pts;
        return h;
    }

    public String toString() {
        return "UpdateReadChannelInbox{identifier=" + this.identifier + ", flags=" + this.flags + ", folderId=" + this.folderId + ", channelId=" + this.channelId + ", maxId=" + this.maxId + ", stillUnreadCount=" + this.stillUnreadCount + ", pts=" + this.pts + "}";
    }

    public static ImmutableUpdateReadChannelInbox of(long channelId, int maxId, int stillUnreadCount, int pts) {
        return new ImmutableUpdateReadChannelInbox(channelId, maxId, stillUnreadCount, pts);
    }

    public static ImmutableUpdateReadChannelInbox copyOf(UpdateReadChannelInbox instance) {
        if (instance instanceof ImmutableUpdateReadChannelInbox) {
            return (ImmutableUpdateReadChannelInbox)instance;
        }
        return ImmutableUpdateReadChannelInbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long INIT_BIT_STILL_UNREAD_COUNT = 4L;
        private static final long INIT_BIT_PTS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer folderId;
        private long channelId;
        private int maxId;
        private int stillUnreadCount;
        private int pts;

        private Builder() {
        }

        public final Builder from(UpdateReadChannelInbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateReadChannelInbox) {
                instance = (UpdateReadChannelInbox)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.flags(instance.flags());
                Integer folderIdValue = instance.folderId();
                if (folderIdValue != null) {
                    this.folderId(folderIdValue);
                }
                this.channelId(instance.channelId());
                this.stillUnreadCount(instance.stillUnreadCount());
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stillUnreadCount(int stillUnreadCount) {
            this.stillUnreadCount = stillUnreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateReadChannelInbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadChannelInbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stillUnreadCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("pts");
            }
            return "Cannot build UpdateReadChannelInbox, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateReadChannelInbox.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateReadChannelInbox.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateReadChannelInbox, attribute initializers form cycle " + attributes;
        }
    }
}

