/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadChannelOutbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadChannelOutbox
implements UpdateReadChannelOutbox {
    private final int identifier;
    private final long channelId;
    private final int maxId;

    private ImmutableUpdateReadChannelOutbox(long channelId, int maxId) {
        this.channelId = channelId;
        this.maxId = maxId;
        this.identifier = UpdateReadChannelOutbox.super.identifier();
    }

    private ImmutableUpdateReadChannelOutbox(Builder builder) {
        this.channelId = builder.channelId;
        this.maxId = builder.maxId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateReadChannelOutbox.super.identifier();
    }

    private ImmutableUpdateReadChannelOutbox(int identifier, long channelId, int maxId) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.maxId = maxId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    public final ImmutableUpdateReadChannelOutbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelOutbox(value, this.channelId, this.maxId);
    }

    public final ImmutableUpdateReadChannelOutbox withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelOutbox(this.identifier, value, this.maxId);
    }

    public final ImmutableUpdateReadChannelOutbox withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableUpdateReadChannelOutbox(this.identifier, this.channelId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadChannelOutbox && this.equalTo(0, (ImmutableUpdateReadChannelOutbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadChannelOutbox another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.maxId == another.maxId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.maxId;
        return h;
    }

    public String toString() {
        return "UpdateReadChannelOutbox{identifier=" + this.identifier + ", channelId=" + this.channelId + ", maxId=" + this.maxId + "}";
    }

    public static ImmutableUpdateReadChannelOutbox of(long channelId, int maxId) {
        return new ImmutableUpdateReadChannelOutbox(channelId, maxId);
    }

    public static ImmutableUpdateReadChannelOutbox copyOf(UpdateReadChannelOutbox instance) {
        if (instance instanceof ImmutableUpdateReadChannelOutbox) {
            return (ImmutableUpdateReadChannelOutbox)instance;
        }
        return ImmutableUpdateReadChannelOutbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long channelId;
        private int maxId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateReadChannelOutbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateReadChannelOutbox) {
                instance = (UpdateReadChannelOutbox)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.channelId(instance.channelId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateReadChannelOutbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadChannelOutbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            return "Cannot build UpdateReadChannelOutbox, some of required attributes are not set " + attributes;
        }
    }
}

