/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadHistoryInbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadHistoryInbox
implements UpdateReadHistoryInbox {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer folderId;
    private final Peer peer;
    private final int maxId;
    private final int stillUnreadCount;
    private final int pts;
    private final int ptsCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateReadHistoryInbox(Peer peer, int maxId, int stillUnreadCount, int pts, int ptsCount) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.maxId = maxId;
        this.stillUnreadCount = stillUnreadCount;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.folderId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadHistoryInbox(Builder builder) {
        this.folderId = builder.folderId;
        this.peer = builder.peer;
        this.maxId = builder.maxId;
        this.stillUnreadCount = builder.stillUnreadCount;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateReadHistoryInbox(int identifier, int flags, @Nullable Integer folderId, Peer peer, int maxId, int stillUnreadCount, int pts, int ptsCount) {
        this.identifier = identifier;
        this.flags = flags;
        this.folderId = folderId;
        this.peer = peer;
        this.maxId = maxId;
        this.stillUnreadCount = stillUnreadCount;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateReadHistoryInbox.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateReadHistoryInbox.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int stillUnreadCount() {
        return this.stillUnreadCount;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateReadHistoryInbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(value, this.flags, this.folderId, this.peer, this.maxId, this.stillUnreadCount, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, value, this.folderId, this.peer, this.maxId, this.stillUnreadCount, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, value, this.peer, this.maxId, this.stillUnreadCount, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, this.folderId, newValue, this.maxId, this.stillUnreadCount, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, this.folderId, this.peer, value, this.stillUnreadCount, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withStillUnreadCount(int value) {
        if (this.stillUnreadCount == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, this.folderId, this.peer, this.maxId, value, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, this.folderId, this.peer, this.maxId, this.stillUnreadCount, value, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryInbox withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryInbox(this.identifier, this.flags, this.folderId, this.peer, this.maxId, this.stillUnreadCount, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadHistoryInbox && this.equalTo(0, (ImmutableUpdateReadHistoryInbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadHistoryInbox another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.folderId, another.folderId) && this.peer.equals(another.peer) && this.maxId == another.maxId && this.stillUnreadCount == another.stillUnreadCount && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.stillUnreadCount;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateReadHistoryInbox{identifier=" + this.identifier + ", flags=" + this.flags + ", folderId=" + this.folderId + ", peer=" + this.peer + ", maxId=" + this.maxId + ", stillUnreadCount=" + this.stillUnreadCount + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateReadHistoryInbox of(Peer peer, int maxId, int stillUnreadCount, int pts, int ptsCount) {
        return new ImmutableUpdateReadHistoryInbox(peer, maxId, stillUnreadCount, pts, ptsCount);
    }

    public static ImmutableUpdateReadHistoryInbox copyOf(UpdateReadHistoryInbox instance) {
        if (instance instanceof ImmutableUpdateReadHistoryInbox) {
            return (ImmutableUpdateReadHistoryInbox)instance;
        }
        return ImmutableUpdateReadHistoryInbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long INIT_BIT_STILL_UNREAD_COUNT = 4L;
        private static final long INIT_BIT_PTS = 8L;
        private static final long INIT_BIT_PTS_COUNT = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer folderId;
        private Peer peer;
        private int maxId;
        private int stillUnreadCount;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateReadHistoryInbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateReadHistoryInbox) {
                instance = (UpdateReadHistoryInbox)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.ptsCount(instance.ptsCount());
                Integer folderIdValue = instance.folderId();
                if (folderIdValue != null) {
                    this.folderId(folderIdValue);
                }
                this.stillUnreadCount(instance.stillUnreadCount());
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stillUnreadCount(int stillUnreadCount) {
            this.stillUnreadCount = stillUnreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableUpdateReadHistoryInbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadHistoryInbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("stillUnreadCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateReadHistoryInbox, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateReadHistoryInbox.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateReadHistoryInbox.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateReadHistoryInbox, attribute initializers form cycle " + attributes;
        }
    }
}

