/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadHistoryOutbox;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadHistoryOutbox
implements UpdateReadHistoryOutbox {
    private final int identifier;
    private final Peer peer;
    private final int maxId;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateReadHistoryOutbox(Peer peer, int maxId, int pts, int ptsCount) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.maxId = maxId;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.identifier = UpdateReadHistoryOutbox.super.identifier();
    }

    private ImmutableUpdateReadHistoryOutbox(Builder builder) {
        this.peer = builder.peer;
        this.maxId = builder.maxId;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateReadHistoryOutbox.super.identifier();
    }

    private ImmutableUpdateReadHistoryOutbox(int identifier, Peer peer, int maxId, int pts, int ptsCount) {
        this.identifier = identifier;
        this.peer = peer;
        this.maxId = maxId;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int maxId() {
        return this.maxId;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateReadHistoryOutbox withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryOutbox(value, this.peer, this.maxId, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryOutbox withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateReadHistoryOutbox(this.identifier, newValue, this.maxId, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryOutbox withMaxId(int value) {
        if (this.maxId == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryOutbox(this.identifier, this.peer, value, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryOutbox withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryOutbox(this.identifier, this.peer, this.maxId, value, this.ptsCount);
    }

    public final ImmutableUpdateReadHistoryOutbox withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateReadHistoryOutbox(this.identifier, this.peer, this.maxId, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadHistoryOutbox && this.equalTo(0, (ImmutableUpdateReadHistoryOutbox)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadHistoryOutbox another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.maxId == another.maxId && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.maxId;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateReadHistoryOutbox{identifier=" + this.identifier + ", peer=" + this.peer + ", maxId=" + this.maxId + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateReadHistoryOutbox of(Peer peer, int maxId, int pts, int ptsCount) {
        return new ImmutableUpdateReadHistoryOutbox(peer, maxId, pts, ptsCount);
    }

    public static ImmutableUpdateReadHistoryOutbox copyOf(UpdateReadHistoryOutbox instance) {
        if (instance instanceof ImmutableUpdateReadHistoryOutbox) {
            return (ImmutableUpdateReadHistoryOutbox)instance;
        }
        return ImmutableUpdateReadHistoryOutbox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MAX_ID = 2L;
        private static final long INIT_BIT_PTS = 4L;
        private static final long INIT_BIT_PTS_COUNT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int maxId;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateReadHistoryOutbox instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateReadHistoryOutbox) {
                instance = (UpdateReadHistoryOutbox)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxId(instance.maxId());
                this.peer(instance.peer());
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxId(int maxId) {
            this.maxId = maxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateReadHistoryOutbox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadHistoryOutbox(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateReadHistoryOutbox, some of required attributes are not set " + attributes;
        }
    }
}

