/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateReadMessagesContents;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateReadMessagesContents
implements UpdateReadMessagesContents {
    private final int identifier;
    private final List<Integer> messages;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateReadMessagesContents(int pts, int ptsCount) {
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.messages = Collections.emptyList();
        this.identifier = UpdateReadMessagesContents.super.identifier();
    }

    private ImmutableUpdateReadMessagesContents(Builder builder) {
        this.messages = ImmutableUpdateReadMessagesContents.createUnmodifiableList(true, builder.messages);
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateReadMessagesContents.super.identifier();
    }

    private ImmutableUpdateReadMessagesContents(int identifier, List<Integer> messages, int pts, int ptsCount) {
        this.identifier = identifier;
        this.messages = messages;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Integer> messages() {
        return this.messages;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateReadMessagesContents withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateReadMessagesContents(value, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadMessagesContents withMessages(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableUpdateReadMessagesContents.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdateReadMessagesContents(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadMessagesContents withMessages(Iterable<Integer> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableUpdateReadMessagesContents.createUnmodifiableList(false, ImmutableUpdateReadMessagesContents.createSafeList(elements, true, false));
        return new ImmutableUpdateReadMessagesContents(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateReadMessagesContents withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateReadMessagesContents(this.identifier, this.messages, value, this.ptsCount);
    }

    public final ImmutableUpdateReadMessagesContents withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateReadMessagesContents(this.identifier, this.messages, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateReadMessagesContents && this.equalTo(0, (ImmutableUpdateReadMessagesContents)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateReadMessagesContents another) {
        return this.identifier == another.identifier && this.messages.equals(another.messages) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateReadMessagesContents{identifier=" + this.identifier + ", messages=" + this.messages + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateReadMessagesContents of(int pts, int ptsCount) {
        return new ImmutableUpdateReadMessagesContents(pts, ptsCount);
    }

    public static ImmutableUpdateReadMessagesContents copyOf(UpdateReadMessagesContents instance) {
        if (instance instanceof ImmutableUpdateReadMessagesContents) {
            return (ImmutableUpdateReadMessagesContents)instance;
        }
        return ImmutableUpdateReadMessagesContents.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_PTS_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private List<Integer> messages = new ArrayList<Integer>();
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateReadMessagesContents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateReadMessagesContents) {
                instance = (UpdateReadMessagesContents)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMessages(instance.messages());
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMessage(int element) {
            this.messages.add(element);
            return this;
        }

        public final Builder addMessages(int ... elements) {
            for (int element : elements) {
                this.messages.add(element);
            }
            return this;
        }

        public final Builder messages(Iterable<Integer> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateReadMessagesContents build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateReadMessagesContents(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateReadMessagesContents, some of required attributes are not set " + attributes;
        }
    }
}

