/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateServiceNotification;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateServiceNotification
implements UpdateServiceNotification {
    private final int identifier;
    private final int flags;
    private final boolean popup;
    @Nullable
    private final Integer inboxDate;
    private final String type;
    private final String message;
    private final MessageMedia media;
    private final List<MessageEntity> entities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateServiceNotification(String type, String message, MessageMedia media) {
        this.type = Objects.requireNonNull(type, "type");
        this.message = Objects.requireNonNull(message, "message");
        this.media = Objects.requireNonNull(media, "media");
        this.inboxDate = null;
        this.entities = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.popup = this.initShim.popup();
        this.initShim = null;
    }

    private ImmutableUpdateServiceNotification(Builder builder) {
        this.inboxDate = builder.inboxDate;
        this.type = builder.type;
        this.message = builder.message;
        this.media = builder.media;
        this.entities = ImmutableUpdateServiceNotification.createUnmodifiableList(true, builder.entities);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.popupIsSet()) {
            this.initShim.popup(builder.popup);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.popup = this.initShim.popup();
        this.initShim = null;
    }

    private ImmutableUpdateServiceNotification(int identifier, int flags, boolean popup, @Nullable Integer inboxDate, String type, String message, MessageMedia media, List<MessageEntity> entities) {
        this.identifier = identifier;
        this.flags = flags;
        this.popup = popup;
        this.inboxDate = inboxDate;
        this.type = type;
        this.message = message;
        this.media = media;
        this.entities = entities;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateServiceNotification.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateServiceNotification.super.flags();
    }

    private boolean popupInitialize() {
        return UpdateServiceNotification.super.popup();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean popup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.popup() : this.popup;
    }

    @Override
    @Nullable
    public Integer inboxDate() {
        return this.inboxDate;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public MessageMedia media() {
        return this.media;
    }

    @Override
    public List<MessageEntity> entities() {
        return this.entities;
    }

    public final ImmutableUpdateServiceNotification withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(value, this.flags, this.popup, this.inboxDate, this.type, this.message, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(this.identifier, value, this.popup, this.inboxDate, this.type, this.message, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withPopup(boolean value) {
        if (this.popup == value) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, value, this.inboxDate, this.type, this.message, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withInboxDate(@Nullable Integer value) {
        if (Objects.equals(this.inboxDate, value)) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, value, this.type, this.message, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, this.inboxDate, newValue, this.message, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, this.inboxDate, this.type, newValue, this.media, this.entities);
    }

    public final ImmutableUpdateServiceNotification withMedia(MessageMedia value) {
        if (this.media == value) {
            return this;
        }
        MessageMedia newValue = Objects.requireNonNull(value, "media");
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, this.inboxDate, this.type, this.message, newValue, this.entities);
    }

    public final ImmutableUpdateServiceNotification withEntities(MessageEntity ... elements) {
        List<MessageEntity> newValue = ImmutableUpdateServiceNotification.createUnmodifiableList(false, ImmutableUpdateServiceNotification.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, this.inboxDate, this.type, this.message, this.media, newValue);
    }

    public final ImmutableUpdateServiceNotification withEntities(Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = ImmutableUpdateServiceNotification.createUnmodifiableList(false, ImmutableUpdateServiceNotification.createSafeList(elements, true, false));
        return new ImmutableUpdateServiceNotification(this.identifier, this.flags, this.popup, this.inboxDate, this.type, this.message, this.media, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateServiceNotification && this.equalTo(0, (ImmutableUpdateServiceNotification)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateServiceNotification another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.popup == another.popup && Objects.equals(this.inboxDate, another.inboxDate) && this.type.equals(another.type) && this.message.equals(another.message) && this.media.equals(another.media) && this.entities.equals(another.entities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.popup);
        h += (h << 5) + Objects.hashCode(this.inboxDate);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.media.hashCode();
        h += (h << 5) + this.entities.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateServiceNotification{identifier=" + this.identifier + ", flags=" + this.flags + ", popup=" + this.popup + ", inboxDate=" + this.inboxDate + ", type=" + this.type + ", message=" + this.message + ", media=" + this.media + ", entities=" + this.entities + "}";
    }

    public static ImmutableUpdateServiceNotification of(String type, String message, MessageMedia media) {
        return new ImmutableUpdateServiceNotification(type, message, media);
    }

    public static ImmutableUpdateServiceNotification copyOf(UpdateServiceNotification instance) {
        if (instance instanceof ImmutableUpdateServiceNotification) {
            return (ImmutableUpdateServiceNotification)instance;
        }
        return ImmutableUpdateServiceNotification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long INIT_BIT_MEDIA = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_POPUP = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean popup;
        private Integer inboxDate;
        private String type;
        private String message;
        private MessageMedia media;
        private List<MessageEntity> entities = new ArrayList<MessageEntity>();

        private Builder() {
        }

        public final Builder from(UpdateServiceNotification instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateServiceNotification) {
                instance = (UpdateServiceNotification)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.popup(instance.popup());
                this.addAllEntities(instance.entities());
                this.flags(instance.flags());
                this.media(instance.media());
                this.type(instance.type());
                this.message(instance.message());
                Integer inboxDateValue = instance.inboxDate();
                if (inboxDateValue != null) {
                    this.inboxDate(inboxDateValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder popup(boolean popup) {
            this.popup = popup;
            this.optBits |= 4L;
            return this;
        }

        public final Builder inboxDate(@Nullable Integer inboxDate) {
            this.inboxDate = inboxDate;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder media(MessageMedia media) {
            this.media = Objects.requireNonNull(media, "media");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(Iterable<? extends MessageEntity> elements) {
            this.entities.clear();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public ImmutableUpdateServiceNotification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateServiceNotification(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean popupIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("media");
            }
            return "Cannot build UpdateServiceNotification, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte popupBuildStage = 0;
        private boolean popup;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateServiceNotification.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateServiceNotification.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean popup() {
            if (this.popupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.popupBuildStage == 0) {
                this.popupBuildStage = (byte)-1;
                this.popup = ImmutableUpdateServiceNotification.this.popupInitialize();
                this.popupBuildStage = 1;
            }
            return this.popup;
        }

        void popup(boolean popup) {
            this.popup = popup;
            this.popupBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.popupBuildStage == -1) {
                attributes.add("popup");
            }
            return "Cannot build UpdateServiceNotification, attribute initializers form cycle " + attributes;
        }
    }
}

