/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateShort;
import telegram4j.tl.Updates;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateShort
implements UpdateShort {
    private final int identifier;
    private final Update update;
    private final int date;

    private ImmutableUpdateShort(Update update, int date) {
        this.update = Objects.requireNonNull(update, "update");
        this.date = date;
        this.identifier = UpdateShort.super.identifier();
    }

    private ImmutableUpdateShort(Builder builder) {
        this.update = builder.update;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateShort.super.identifier();
    }

    private ImmutableUpdateShort(int identifier, Update update, int date) {
        this.identifier = identifier;
        this.update = update;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Update update() {
        return this.update;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableUpdateShort withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateShort(value, this.update, this.date);
    }

    public final ImmutableUpdateShort withUpdate(Update value) {
        if (this.update == value) {
            return this;
        }
        Update newValue = Objects.requireNonNull(value, "update");
        return new ImmutableUpdateShort(this.identifier, newValue, this.date);
    }

    public final ImmutableUpdateShort withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateShort(this.identifier, this.update, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateShort && this.equalTo(0, (ImmutableUpdateShort)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateShort another) {
        return this.identifier == another.identifier && this.update.equals(another.update) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.update.hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "UpdateShort{identifier=" + this.identifier + ", update=" + this.update + ", date=" + this.date + "}";
    }

    public static ImmutableUpdateShort of(Update update, int date) {
        return new ImmutableUpdateShort(update, date);
    }

    public static ImmutableUpdateShort copyOf(UpdateShort instance) {
        if (instance instanceof ImmutableUpdateShort) {
            return (ImmutableUpdateShort)instance;
        }
        return ImmutableUpdateShort.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_UPDATE = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Update update;
        private int date;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Updates instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateShort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Updates) {
                instance = (Updates)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateShort) {
                instance = (UpdateShort)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.update(instance.update());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder update(Update update) {
            this.update = Objects.requireNonNull(update, "update");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateShort build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateShort(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("update");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build UpdateShort, some of required attributes are not set " + attributes;
        }
    }
}

