/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageFwdHeader;
import telegram4j.tl.MessageReplyHeader;
import telegram4j.tl.UpdateShortChatMessage;
import telegram4j.tl.Updates;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateShortChatMessage
implements UpdateShortChatMessage {
    private final int identifier;
    private final int flags;
    private final boolean out;
    private final boolean mentioned;
    private final boolean mediaUnread;
    private final boolean silent;
    private final int id;
    private final long fromId;
    private final long chatId;
    private final String message;
    private final int pts;
    private final int ptsCount;
    private final int date;
    @Nullable
    private final MessageFwdHeader fwdFrom;
    @Nullable
    private final Long viaBotId;
    @Nullable
    private final MessageReplyHeader replyTo;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer ttlPeriod;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateShortChatMessage(int id, long fromId, long chatId, String message, int pts, int ptsCount, int date) {
        this.id = id;
        this.fromId = fromId;
        this.chatId = chatId;
        this.message = Objects.requireNonNull(message, "message");
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.fwdFrom = null;
        this.viaBotId = null;
        this.replyTo = null;
        this.entities = null;
        this.ttlPeriod = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableUpdateShortChatMessage(Builder builder) {
        this.id = builder.id;
        this.fromId = builder.fromId;
        this.chatId = builder.chatId;
        this.message = builder.message;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.date = builder.date;
        this.fwdFrom = builder.fwdFrom;
        this.viaBotId = builder.viaBotId;
        this.replyTo = builder.replyTo;
        this.entities = builder.entities == null ? null : ImmutableUpdateShortChatMessage.createUnmodifiableList(true, builder.entities);
        this.ttlPeriod = builder.ttlPeriod;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.outIsSet()) {
            this.initShim.out(builder.out);
        }
        if (builder.mentionedIsSet()) {
            this.initShim.mentioned(builder.mentioned);
        }
        if (builder.mediaUnreadIsSet()) {
            this.initShim.mediaUnread(builder.mediaUnread);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.initShim = null;
    }

    private ImmutableUpdateShortChatMessage(int identifier, int flags, boolean out, boolean mentioned, boolean mediaUnread, boolean silent, int id, long fromId, long chatId, String message, int pts, int ptsCount, int date, @Nullable MessageFwdHeader fwdFrom, @Nullable Long viaBotId, @Nullable MessageReplyHeader replyTo, @Nullable List<MessageEntity> entities, @Nullable Integer ttlPeriod) {
        this.identifier = identifier;
        this.flags = flags;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.silent = silent;
        this.id = id;
        this.fromId = fromId;
        this.chatId = chatId;
        this.message = message;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.fwdFrom = fwdFrom;
        this.viaBotId = viaBotId;
        this.replyTo = replyTo;
        this.entities = entities;
        this.ttlPeriod = ttlPeriod;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateShortChatMessage.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateShortChatMessage.super.flags();
    }

    private boolean outInitialize() {
        return UpdateShortChatMessage.super.out();
    }

    private boolean mentionedInitialize() {
        return UpdateShortChatMessage.super.mentioned();
    }

    private boolean mediaUnreadInitialize() {
        return UpdateShortChatMessage.super.mediaUnread();
    }

    private boolean silentInitialize() {
        return UpdateShortChatMessage.super.silent();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean out() {
        InitShim shim = this.initShim;
        return shim != null ? shim.out() : this.out;
    }

    @Override
    public boolean mentioned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mentioned() : this.mentioned;
    }

    @Override
    public boolean mediaUnread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mediaUnread() : this.mediaUnread;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long fromId() {
        return this.fromId;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public MessageFwdHeader fwdFrom() {
        return this.fwdFrom;
    }

    @Override
    @Nullable
    public Long viaBotId() {
        return this.viaBotId;
    }

    @Override
    @Nullable
    public MessageReplyHeader replyTo() {
        return this.replyTo;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    public final ImmutableUpdateShortChatMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(value, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, value, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withOut(boolean value) {
        if (this.out == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, value, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withMentioned(boolean value) {
        if (this.mentioned == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, value, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withMediaUnread(boolean value) {
        if (this.mediaUnread == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, value, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, value, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, value, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withFromId(long value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, value, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, value, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, newValue, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, value, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, value, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, value, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withFwdFrom(@Nullable MessageFwdHeader value) {
        if (this.fwdFrom == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, value, this.viaBotId, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withViaBotId(@Nullable Long value) {
        if (Objects.equals(this.viaBotId, value)) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, value, this.replyTo, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withReplyTo(@Nullable MessageReplyHeader value) {
        if (this.replyTo == value) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, value, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, null, this.ttlPeriod);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableUpdateShortChatMessage.createUnmodifiableList(false, ImmutableUpdateShortChatMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, newValue, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableUpdateShortChatMessage.createUnmodifiableList(false, ImmutableUpdateShortChatMessage.createSafeList(elements, true, false));
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, newValue, this.ttlPeriod);
    }

    public final ImmutableUpdateShortChatMessage withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableUpdateShortChatMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.id, this.fromId, this.chatId, this.message, this.pts, this.ptsCount, this.date, this.fwdFrom, this.viaBotId, this.replyTo, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateShortChatMessage && this.equalTo(0, (ImmutableUpdateShortChatMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateShortChatMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.out == another.out && this.mentioned == another.mentioned && this.mediaUnread == another.mediaUnread && this.silent == another.silent && this.id == another.id && this.fromId == another.fromId && this.chatId == another.chatId && this.message.equals(another.message) && this.pts == another.pts && this.ptsCount == another.ptsCount && this.date == another.date && Objects.equals(this.fwdFrom, another.fwdFrom) && Objects.equals(this.viaBotId, another.viaBotId) && Objects.equals(this.replyTo, another.replyTo) && Objects.equals(this.entities, another.entities) && Objects.equals(this.ttlPeriod, another.ttlPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.out);
        h += (h << 5) + Boolean.hashCode(this.mentioned);
        h += (h << 5) + Boolean.hashCode(this.mediaUnread);
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.fromId);
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.fwdFrom);
        h += (h << 5) + Objects.hashCode(this.viaBotId);
        h += (h << 5) + Objects.hashCode(this.replyTo);
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        return h;
    }

    public String toString() {
        return "UpdateShortChatMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", out=" + this.out + ", mentioned=" + this.mentioned + ", mediaUnread=" + this.mediaUnread + ", silent=" + this.silent + ", id=" + this.id + ", fromId=" + this.fromId + ", chatId=" + this.chatId + ", message=" + this.message + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + ", date=" + this.date + ", fwdFrom=" + this.fwdFrom + ", viaBotId=" + this.viaBotId + ", replyTo=" + this.replyTo + ", entities=" + this.entities + ", ttlPeriod=" + this.ttlPeriod + "}";
    }

    public static ImmutableUpdateShortChatMessage of(int id, long fromId, long chatId, String message, int pts, int ptsCount, int date) {
        return new ImmutableUpdateShortChatMessage(id, fromId, chatId, message, pts, ptsCount, date);
    }

    public static ImmutableUpdateShortChatMessage copyOf(UpdateShortChatMessage instance) {
        if (instance instanceof ImmutableUpdateShortChatMessage) {
            return (ImmutableUpdateShortChatMessage)instance;
        }
        return ImmutableUpdateShortChatMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_FROM_ID = 2L;
        private static final long INIT_BIT_CHAT_ID = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private static final long INIT_BIT_PTS = 16L;
        private static final long INIT_BIT_PTS_COUNT = 32L;
        private static final long INIT_BIT_DATE = 64L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OUT = 4L;
        private static final long OPT_BIT_MENTIONED = 8L;
        private static final long OPT_BIT_MEDIA_UNREAD = 16L;
        private static final long OPT_BIT_SILENT = 32L;
        private long initBits = 127L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean out;
        private boolean mentioned;
        private boolean mediaUnread;
        private boolean silent;
        private int id;
        private long fromId;
        private long chatId;
        private String message;
        private int pts;
        private int ptsCount;
        private int date;
        private MessageFwdHeader fwdFrom;
        private Long viaBotId;
        private MessageReplyHeader replyTo;
        private List<MessageEntity> entities = null;
        private Integer ttlPeriod;

        private Builder() {
        }

        public final Builder from(UpdateShortChatMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Updates instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Updates instance;
            long bits = 0L;
            if (object instanceof UpdateShortChatMessage) {
                Integer ttlPeriodValue;
                List<MessageEntity> entitiesValue;
                Long viaBotIdValue;
                instance = (UpdateShortChatMessage)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((viaBotIdValue = instance.viaBotId()) != null) {
                    this.viaBotId(viaBotIdValue);
                }
                this.silent(instance.silent());
                this.chatId(instance.chatId());
                this.flags(instance.flags());
                this.message(instance.message());
                this.fromId(instance.fromId());
                this.pts(instance.pts());
                this.out(instance.out());
                this.mediaUnread(instance.mediaUnread());
                MessageFwdHeader fwdFromValue = instance.fwdFrom();
                if (fwdFromValue != null) {
                    this.fwdFrom(fwdFromValue);
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                this.ptsCount(instance.ptsCount());
                MessageReplyHeader replyToValue = instance.replyTo();
                if (replyToValue != null) {
                    this.replyTo(replyToValue);
                }
                if ((ttlPeriodValue = instance.ttlPeriod()) != null) {
                    this.ttlPeriod(ttlPeriodValue);
                }
                this.id(instance.id());
                this.mentioned(instance.mentioned());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Updates) {
                instance = (Updates)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder out(boolean out) {
            this.out = out;
            this.optBits |= 4L;
            return this;
        }

        public final Builder mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.optBits |= 8L;
            return this;
        }

        public final Builder mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromId(long fromId) {
            this.fromId = fromId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder fwdFrom(@Nullable MessageFwdHeader fwdFrom) {
            this.fwdFrom = fwdFrom;
            return this;
        }

        public final Builder viaBotId(@Nullable Long viaBotId) {
            this.viaBotId = viaBotId;
            return this;
        }

        public final Builder replyTo(@Nullable MessageReplyHeader replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public ImmutableUpdateShortChatMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateShortChatMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean outIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mentionedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean mediaUnreadIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ptsCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build UpdateShortChatMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte outBuildStage = 0;
        private boolean out;
        private byte mentionedBuildStage = 0;
        private boolean mentioned;
        private byte mediaUnreadBuildStage = 0;
        private boolean mediaUnread;
        private byte silentBuildStage = 0;
        private boolean silent;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateShortChatMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateShortChatMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean out() {
            if (this.outBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outBuildStage == 0) {
                this.outBuildStage = (byte)-1;
                this.out = ImmutableUpdateShortChatMessage.this.outInitialize();
                this.outBuildStage = 1;
            }
            return this.out;
        }

        void out(boolean out) {
            this.out = out;
            this.outBuildStage = 1;
        }

        boolean mentioned() {
            if (this.mentionedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mentionedBuildStage == 0) {
                this.mentionedBuildStage = (byte)-1;
                this.mentioned = ImmutableUpdateShortChatMessage.this.mentionedInitialize();
                this.mentionedBuildStage = 1;
            }
            return this.mentioned;
        }

        void mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.mentionedBuildStage = 1;
        }

        boolean mediaUnread() {
            if (this.mediaUnreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mediaUnreadBuildStage == 0) {
                this.mediaUnreadBuildStage = (byte)-1;
                this.mediaUnread = ImmutableUpdateShortChatMessage.this.mediaUnreadInitialize();
                this.mediaUnreadBuildStage = 1;
            }
            return this.mediaUnread;
        }

        void mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.mediaUnreadBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableUpdateShortChatMessage.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.outBuildStage == -1) {
                attributes.add("out");
            }
            if (this.mentionedBuildStage == -1) {
                attributes.add("mentioned");
            }
            if (this.mediaUnreadBuildStage == -1) {
                attributes.add("mediaUnread");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            return "Cannot build UpdateShortChatMessage, attribute initializers form cycle " + attributes;
        }
    }
}

