/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.UpdateShortSentMessage;
import telegram4j.tl.Updates;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateShortSentMessage
implements UpdateShortSentMessage {
    private final int identifier;
    private final int flags;
    private final boolean out;
    private final int id;
    private final int pts;
    private final int ptsCount;
    private final int date;
    @Nullable
    private final MessageMedia media;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer ttlPeriod;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateShortSentMessage(int id, int pts, int ptsCount, int date) {
        this.id = id;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.media = null;
        this.entities = null;
        this.ttlPeriod = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.initShim = null;
    }

    private ImmutableUpdateShortSentMessage(Builder builder) {
        this.id = builder.id;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.date = builder.date;
        this.media = builder.media;
        this.entities = builder.entities == null ? null : ImmutableUpdateShortSentMessage.createUnmodifiableList(true, builder.entities);
        this.ttlPeriod = builder.ttlPeriod;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.outIsSet()) {
            this.initShim.out(builder.out);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.initShim = null;
    }

    private ImmutableUpdateShortSentMessage(int identifier, int flags, boolean out, int id, int pts, int ptsCount, int date, @Nullable MessageMedia media, @Nullable List<MessageEntity> entities, @Nullable Integer ttlPeriod) {
        this.identifier = identifier;
        this.flags = flags;
        this.out = out;
        this.id = id;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.date = date;
        this.media = media;
        this.entities = entities;
        this.ttlPeriod = ttlPeriod;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateShortSentMessage.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateShortSentMessage.super.flags();
    }

    private boolean outInitialize() {
        return UpdateShortSentMessage.super.out();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean out() {
        InitShim shim = this.initShim;
        return shim != null ? shim.out() : this.out;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public MessageMedia media() {
        return this.media;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    public final ImmutableUpdateShortSentMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(value, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, value, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withOut(boolean value) {
        if (this.out == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, value, this.id, this.pts, this.ptsCount, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, value, this.pts, this.ptsCount, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, value, this.ptsCount, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, value, this.date, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, value, this.media, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withMedia(@Nullable MessageMedia value) {
        if (this.media == value) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, value, this.entities, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, null, this.ttlPeriod);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableUpdateShortSentMessage.createUnmodifiableList(false, ImmutableUpdateShortSentMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, newValue, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableUpdateShortSentMessage.createUnmodifiableList(false, ImmutableUpdateShortSentMessage.createSafeList(elements, true, false));
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, newValue, this.ttlPeriod);
    }

    public final ImmutableUpdateShortSentMessage withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableUpdateShortSentMessage(this.identifier, this.flags, this.out, this.id, this.pts, this.ptsCount, this.date, this.media, this.entities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateShortSentMessage && this.equalTo(0, (ImmutableUpdateShortSentMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateShortSentMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.out == another.out && this.id == another.id && this.pts == another.pts && this.ptsCount == another.ptsCount && this.date == another.date && Objects.equals(this.media, another.media) && Objects.equals(this.entities, another.entities) && Objects.equals(this.ttlPeriod, another.ttlPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.out);
        h += (h << 5) + this.id;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.media);
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        return h;
    }

    public String toString() {
        return "UpdateShortSentMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", out=" + this.out + ", id=" + this.id + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + ", date=" + this.date + ", media=" + this.media + ", entities=" + this.entities + ", ttlPeriod=" + this.ttlPeriod + "}";
    }

    public static ImmutableUpdateShortSentMessage of(int id, int pts, int ptsCount, int date) {
        return new ImmutableUpdateShortSentMessage(id, pts, ptsCount, date);
    }

    public static ImmutableUpdateShortSentMessage copyOf(UpdateShortSentMessage instance) {
        if (instance instanceof ImmutableUpdateShortSentMessage) {
            return (ImmutableUpdateShortSentMessage)instance;
        }
        return ImmutableUpdateShortSentMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PTS = 2L;
        private static final long INIT_BIT_PTS_COUNT = 4L;
        private static final long INIT_BIT_DATE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OUT = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean out;
        private int id;
        private int pts;
        private int ptsCount;
        private int date;
        private MessageMedia media;
        private List<MessageEntity> entities = null;
        private Integer ttlPeriod;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Updates instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateShortSentMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Updates) {
                instance = (Updates)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateShortSentMessage) {
                List<MessageEntity> entitiesValue;
                instance = (UpdateShortSentMessage)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                this.flags(instance.flags());
                this.ptsCount(instance.ptsCount());
                Integer ttlPeriodValue = instance.ttlPeriod();
                if (ttlPeriodValue != null) {
                    this.ttlPeriod(ttlPeriodValue);
                }
                this.id(instance.id());
                MessageMedia mediaValue = instance.media();
                if (mediaValue != null) {
                    this.media(mediaValue);
                }
                this.pts(instance.pts());
                this.out(instance.out());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder out(boolean out) {
            this.out = out;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder media(@Nullable MessageMedia media) {
            this.media = media;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public ImmutableUpdateShortSentMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateShortSentMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean outIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ptsCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build UpdateShortSentMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte outBuildStage = 0;
        private boolean out;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateShortSentMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateShortSentMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean out() {
            if (this.outBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outBuildStage == 0) {
                this.outBuildStage = (byte)-1;
                this.out = ImmutableUpdateShortSentMessage.this.outInitialize();
                this.outBuildStage = 1;
            }
            return this.out;
        }

        void out(boolean out) {
            this.out = out;
            this.outBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.outBuildStage == -1) {
                attributes.add("out");
            }
            return "Cannot build UpdateShortSentMessage, attribute initializers form cycle " + attributes;
        }
    }
}

