/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateStickerSets;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateStickerSets
implements UpdateStickerSets {
    private final int identifier;
    private static final ImmutableUpdateStickerSets INSTANCE = ImmutableUpdateStickerSets.validate(new ImmutableUpdateStickerSets());

    private ImmutableUpdateStickerSets() {
        this.identifier = UpdateStickerSets.super.identifier();
    }

    private ImmutableUpdateStickerSets(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateStickerSets.super.identifier();
    }

    private ImmutableUpdateStickerSets(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUpdateStickerSets withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateStickerSets.validate(new ImmutableUpdateStickerSets(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateStickerSets && this.equalTo(0, (ImmutableUpdateStickerSets)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateStickerSets another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UpdateStickerSets{identifier=" + this.identifier + "}";
    }

    public static ImmutableUpdateStickerSets of() {
        return INSTANCE;
    }

    private static ImmutableUpdateStickerSets validate(ImmutableUpdateStickerSets instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateStickerSets copyOf(UpdateStickerSets instance) {
        if (instance instanceof ImmutableUpdateStickerSets) {
            return (ImmutableUpdateStickerSets)instance;
        }
        return ImmutableUpdateStickerSets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UpdateStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateStickerSets) {
                instance = (UpdateStickerSets)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUpdateStickerSets build() {
            return ImmutableUpdateStickerSets.validate(new ImmutableUpdateStickerSets(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

