/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Theme;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateTheme;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateTheme
implements UpdateTheme {
    private final int identifier;
    private final Theme theme;

    private ImmutableUpdateTheme(Theme theme) {
        this.theme = Objects.requireNonNull(theme, "theme");
        this.identifier = UpdateTheme.super.identifier();
    }

    private ImmutableUpdateTheme(Builder builder) {
        this.theme = builder.theme;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateTheme.super.identifier();
    }

    private ImmutableUpdateTheme(int identifier, Theme theme) {
        this.identifier = identifier;
        this.theme = theme;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Theme theme() {
        return this.theme;
    }

    public final ImmutableUpdateTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateTheme(value, this.theme);
    }

    public final ImmutableUpdateTheme withTheme(Theme value) {
        if (this.theme == value) {
            return this;
        }
        Theme newValue = Objects.requireNonNull(value, "theme");
        return new ImmutableUpdateTheme(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateTheme && this.equalTo(0, (ImmutableUpdateTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateTheme another) {
        return this.identifier == another.identifier && this.theme.equals(another.theme);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.theme.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateTheme{identifier=" + this.identifier + ", theme=" + this.theme + "}";
    }

    public static ImmutableUpdateTheme of(Theme theme) {
        return new ImmutableUpdateTheme(theme);
    }

    public static ImmutableUpdateTheme copyOf(UpdateTheme instance) {
        if (instance instanceof ImmutableUpdateTheme) {
            return (ImmutableUpdateTheme)instance;
        }
        return ImmutableUpdateTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_THEME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Theme theme;

        private Builder() {
        }

        public final Builder from(UpdateTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateTheme) {
                instance = (UpdateTheme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.theme(instance.theme());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder theme(Theme theme) {
            this.theme = Objects.requireNonNull(theme, "theme");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("theme");
            }
            return "Cannot build UpdateTheme, some of required attributes are not set " + attributes;
        }
    }
}

