/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateTranscribedAudio;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateTranscribedAudio
implements UpdateTranscribedAudio {
    private final int identifier;
    private final int flags;
    private final boolean pending;
    private final Peer peer;
    private final int msgId;
    private final long transcriptionId;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateTranscribedAudio(Peer peer, int msgId, long transcriptionId, String text) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.transcriptionId = transcriptionId;
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pending = this.initShim.pending();
        this.initShim = null;
    }

    private ImmutableUpdateTranscribedAudio(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.transcriptionId = builder.transcriptionId;
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pendingIsSet()) {
            this.initShim.pending(builder.pending);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pending = this.initShim.pending();
        this.initShim = null;
    }

    private ImmutableUpdateTranscribedAudio(int identifier, int flags, boolean pending, Peer peer, int msgId, long transcriptionId, String text) {
        this.identifier = identifier;
        this.flags = flags;
        this.pending = pending;
        this.peer = peer;
        this.msgId = msgId;
        this.transcriptionId = transcriptionId;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateTranscribedAudio.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateTranscribedAudio.super.flags();
    }

    private boolean pendingInitialize() {
        return UpdateTranscribedAudio.super.pending();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pending() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pending() : this.pending;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public long transcriptionId() {
        return this.transcriptionId;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableUpdateTranscribedAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(value, this.flags, this.pending, this.peer, this.msgId, this.transcriptionId, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(this.identifier, value, this.pending, this.peer, this.msgId, this.transcriptionId, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withPending(boolean value) {
        if (this.pending == value) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(this.identifier, this.flags, value, this.peer, this.msgId, this.transcriptionId, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateTranscribedAudio(this.identifier, this.flags, this.pending, newValue, this.msgId, this.transcriptionId, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(this.identifier, this.flags, this.pending, this.peer, value, this.transcriptionId, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withTranscriptionId(long value) {
        if (this.transcriptionId == value) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(this.identifier, this.flags, this.pending, this.peer, this.msgId, value, this.text);
    }

    public final ImmutableUpdateTranscribedAudio withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateTranscribedAudio(this.identifier, this.flags, this.pending, this.peer, this.msgId, this.transcriptionId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateTranscribedAudio && this.equalTo(0, (ImmutableUpdateTranscribedAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateTranscribedAudio another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pending == another.pending && this.peer.equals(another.peer) && this.msgId == another.msgId && this.transcriptionId == another.transcriptionId && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pending);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + Long.hashCode(this.transcriptionId);
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateTranscribedAudio{identifier=" + this.identifier + ", flags=" + this.flags + ", pending=" + this.pending + ", peer=" + this.peer + ", msgId=" + this.msgId + ", transcriptionId=" + this.transcriptionId + ", text=" + this.text + "}";
    }

    public static ImmutableUpdateTranscribedAudio of(Peer peer, int msgId, long transcriptionId, String text) {
        return new ImmutableUpdateTranscribedAudio(peer, msgId, transcriptionId, text);
    }

    public static ImmutableUpdateTranscribedAudio copyOf(UpdateTranscribedAudio instance) {
        if (instance instanceof ImmutableUpdateTranscribedAudio) {
            return (ImmutableUpdateTranscribedAudio)instance;
        }
        return ImmutableUpdateTranscribedAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_TRANSCRIPTION_ID = 4L;
        private static final long INIT_BIT_TEXT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PENDING = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pending;
        private Peer peer;
        private int msgId;
        private long transcriptionId;
        private String text;

        private Builder() {
        }

        public final Builder from(UpdateTranscribedAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateTranscribedAudio) {
                instance = (UpdateTranscribedAudio)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.pending(instance.pending());
                this.transcriptionId(instance.transcriptionId());
                this.flags(instance.flags());
                this.msgId(instance.msgId());
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pending(boolean pending) {
            this.pending = pending;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transcriptionId(long transcriptionId) {
            this.transcriptionId = transcriptionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateTranscribedAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateTranscribedAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pendingIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transcriptionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build UpdateTranscribedAudio, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pendingBuildStage = 0;
        private boolean pending;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateTranscribedAudio.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateTranscribedAudio.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pending() {
            if (this.pendingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pendingBuildStage == 0) {
                this.pendingBuildStage = (byte)-1;
                this.pending = ImmutableUpdateTranscribedAudio.this.pendingInitialize();
                this.pendingBuildStage = 1;
            }
            return this.pending;
        }

        void pending(boolean pending) {
            this.pending = pending;
            this.pendingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pendingBuildStage == -1) {
                attributes.add("pending");
            }
            return "Cannot build UpdateTranscribedAudio, attribute initializers form cycle " + attributes;
        }
    }
}

