/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateUserName;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateUserName
implements UpdateUserName {
    private final int identifier;
    private final long userId;
    private final String firstName;
    private final String lastName;
    private final String username;

    private ImmutableUpdateUserName(long userId, String firstName, String lastName, String username) {
        this.userId = userId;
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.username = Objects.requireNonNull(username, "username");
        this.identifier = UpdateUserName.super.identifier();
    }

    private ImmutableUpdateUserName(Builder builder) {
        this.userId = builder.userId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateUserName.super.identifier();
    }

    private ImmutableUpdateUserName(int identifier, long userId, String firstName, String lastName, String username) {
        this.identifier = identifier;
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public String username() {
        return this.username;
    }

    public final ImmutableUpdateUserName withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateUserName(value, this.userId, this.firstName, this.lastName, this.username);
    }

    public final ImmutableUpdateUserName withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateUserName(this.identifier, value, this.firstName, this.lastName, this.username);
    }

    public final ImmutableUpdateUserName withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateUserName(this.identifier, this.userId, newValue, this.lastName, this.username);
    }

    public final ImmutableUpdateUserName withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateUserName(this.identifier, this.userId, this.firstName, newValue, this.username);
    }

    public final ImmutableUpdateUserName withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateUserName(this.identifier, this.userId, this.firstName, this.lastName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateUserName && this.equalTo(0, (ImmutableUpdateUserName)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateUserName another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateUserName{identifier=" + this.identifier + ", userId=" + this.userId + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", username=" + this.username + "}";
    }

    public static ImmutableUpdateUserName of(long userId, String firstName, String lastName, String username) {
        return new ImmutableUpdateUserName(userId, firstName, lastName, username);
    }

    public static ImmutableUpdateUserName copyOf(UpdateUserName instance) {
        if (instance instanceof ImmutableUpdateUserName) {
            return (ImmutableUpdateUserName)instance;
        }
        return ImmutableUpdateUserName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_USERNAME = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long userId;
        private String firstName;
        private String lastName;
        private String username;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateUserName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateUserName) {
                instance = (UpdateUserName)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.userId(instance.userId());
                this.username(instance.username());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateUserName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateUserName(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build UpdateUserName, some of required attributes are not set " + attributes;
        }
    }
}

