/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateUserPhone;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateUserPhone
implements UpdateUserPhone {
    private final int identifier;
    private final long userId;
    private final String phone;

    private ImmutableUpdateUserPhone(long userId, String phone) {
        this.userId = userId;
        this.phone = Objects.requireNonNull(phone, "phone");
        this.identifier = UpdateUserPhone.super.identifier();
    }

    private ImmutableUpdateUserPhone(Builder builder) {
        this.userId = builder.userId;
        this.phone = builder.phone;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateUserPhone.super.identifier();
    }

    private ImmutableUpdateUserPhone(int identifier, long userId, String phone) {
        this.identifier = identifier;
        this.userId = userId;
        this.phone = phone;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    public final ImmutableUpdateUserPhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateUserPhone(value, this.userId, this.phone);
    }

    public final ImmutableUpdateUserPhone withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateUserPhone(this.identifier, value, this.phone);
    }

    public final ImmutableUpdateUserPhone withPhone(String value) {
        String newValue = Objects.requireNonNull(value, "phone");
        if (this.phone.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateUserPhone(this.identifier, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateUserPhone && this.equalTo(0, (ImmutableUpdateUserPhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateUserPhone another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.phone.equals(another.phone);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.phone.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateUserPhone{identifier=" + this.identifier + ", userId=" + this.userId + ", phone=" + this.phone + "}";
    }

    public static ImmutableUpdateUserPhone of(long userId, String phone) {
        return new ImmutableUpdateUserPhone(userId, phone);
    }

    public static ImmutableUpdateUserPhone copyOf(UpdateUserPhone instance) {
        if (instance instanceof ImmutableUpdateUserPhone) {
            return (ImmutableUpdateUserPhone)instance;
        }
        return ImmutableUpdateUserPhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_PHONE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private String phone;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateUserPhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateUserPhone) {
                instance = (UpdateUserPhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phone(instance.phone());
                this.userId(instance.userId());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phone(String phone) {
            this.phone = Objects.requireNonNull(phone, "phone");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateUserPhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateUserPhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phone");
            }
            return "Cannot build UpdateUserPhone, some of required attributes are not set " + attributes;
        }
    }
}

