/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateUserPhoto;
import telegram4j.tl.UserProfilePhoto;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateUserPhoto
implements UpdateUserPhoto {
    private final int identifier;
    private final long userId;
    private final int date;
    private final UserProfilePhoto photo;
    private final boolean previous;

    private ImmutableUpdateUserPhoto(long userId, int date, UserProfilePhoto photo, boolean previous) {
        this.userId = userId;
        this.date = date;
        this.photo = Objects.requireNonNull(photo, "photo");
        this.previous = previous;
        this.identifier = UpdateUserPhoto.super.identifier();
    }

    private ImmutableUpdateUserPhoto(Builder builder) {
        this.userId = builder.userId;
        this.date = builder.date;
        this.photo = builder.photo;
        this.previous = builder.previous;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateUserPhoto.super.identifier();
    }

    private ImmutableUpdateUserPhoto(int identifier, long userId, int date, UserProfilePhoto photo, boolean previous) {
        this.identifier = identifier;
        this.userId = userId;
        this.date = date;
        this.photo = photo;
        this.previous = previous;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public UserProfilePhoto photo() {
        return this.photo;
    }

    @Override
    public boolean previous() {
        return this.previous;
    }

    public final ImmutableUpdateUserPhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateUserPhoto(value, this.userId, this.date, this.photo, this.previous);
    }

    public final ImmutableUpdateUserPhoto withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateUserPhoto(this.identifier, value, this.date, this.photo, this.previous);
    }

    public final ImmutableUpdateUserPhoto withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateUserPhoto(this.identifier, this.userId, value, this.photo, this.previous);
    }

    public final ImmutableUpdateUserPhoto withPhoto(UserProfilePhoto value) {
        if (this.photo == value) {
            return this;
        }
        UserProfilePhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableUpdateUserPhoto(this.identifier, this.userId, this.date, newValue, this.previous);
    }

    public final ImmutableUpdateUserPhoto withPrevious(boolean value) {
        if (this.previous == value) {
            return this;
        }
        return new ImmutableUpdateUserPhoto(this.identifier, this.userId, this.date, this.photo, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateUserPhoto && this.equalTo(0, (ImmutableUpdateUserPhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateUserPhoto another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.date == another.date && this.photo.equals(another.photo) && this.previous == another.previous;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.date;
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + Boolean.hashCode(this.previous);
        return h;
    }

    public String toString() {
        return "UpdateUserPhoto{identifier=" + this.identifier + ", userId=" + this.userId + ", date=" + this.date + ", photo=" + this.photo + ", previous=" + this.previous + "}";
    }

    public static ImmutableUpdateUserPhoto of(long userId, int date, UserProfilePhoto photo, boolean previous) {
        return new ImmutableUpdateUserPhoto(userId, date, photo, previous);
    }

    public static ImmutableUpdateUserPhoto copyOf(UpdateUserPhoto instance) {
        if (instance instanceof ImmutableUpdateUserPhoto) {
            return (ImmutableUpdateUserPhoto)instance;
        }
        return ImmutableUpdateUserPhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_PHOTO = 4L;
        private static final long INIT_BIT_PREVIOUS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long userId;
        private int date;
        private UserProfilePhoto photo;
        private boolean previous;

        private Builder() {
        }

        public final Builder from(UpdateUserPhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateUserPhoto) {
                instance = (UpdateUserPhoto)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
                this.previous(instance.previous());
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(UserProfilePhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder previous(boolean previous) {
            this.previous = previous;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateUserPhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateUserPhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("photo");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("previous");
            }
            return "Cannot build UpdateUserPhoto, some of required attributes are not set " + attributes;
        }
    }
}

