/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateUserTyping;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateUserTyping
implements UpdateUserTyping {
    private final int identifier;
    private final long userId;
    private final SendMessageAction action;

    private ImmutableUpdateUserTyping(long userId, SendMessageAction action) {
        this.userId = userId;
        this.action = Objects.requireNonNull(action, "action");
        this.identifier = UpdateUserTyping.super.identifier();
    }

    private ImmutableUpdateUserTyping(Builder builder) {
        this.userId = builder.userId;
        this.action = builder.action;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateUserTyping.super.identifier();
    }

    private ImmutableUpdateUserTyping(int identifier, long userId, SendMessageAction action) {
        this.identifier = identifier;
        this.userId = userId;
        this.action = action;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public SendMessageAction action() {
        return this.action;
    }

    public final ImmutableUpdateUserTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateUserTyping(value, this.userId, this.action);
    }

    public final ImmutableUpdateUserTyping withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateUserTyping(this.identifier, value, this.action);
    }

    public final ImmutableUpdateUserTyping withAction(SendMessageAction value) {
        if (this.action == value) {
            return this;
        }
        SendMessageAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableUpdateUserTyping(this.identifier, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateUserTyping && this.equalTo(0, (ImmutableUpdateUserTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateUserTyping another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateUserTyping{identifier=" + this.identifier + ", userId=" + this.userId + ", action=" + this.action + "}";
    }

    public static ImmutableUpdateUserTyping of(long userId, SendMessageAction action) {
        return new ImmutableUpdateUserTyping(userId, action);
    }

    public static ImmutableUpdateUserTyping copyOf(UpdateUserTyping instance) {
        if (instance instanceof ImmutableUpdateUserTyping) {
            return (ImmutableUpdateUserTyping)instance;
        }
        return ImmutableUpdateUserTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_ACTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private SendMessageAction action;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateUserTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateUserTyping) {
                instance = (UpdateUserTyping)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.action(instance.action());
                this.userId(instance.userId());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder action(SendMessageAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateUserTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateUserTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build UpdateUserTyping, some of required attributes are not set " + attributes;
        }
    }
}

