/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateWebPage;
import telegram4j.tl.WebPage;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateWebPage
implements UpdateWebPage {
    private final int identifier;
    private final WebPage webpage;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateWebPage(WebPage webpage, int pts, int ptsCount) {
        this.webpage = Objects.requireNonNull(webpage, "webpage");
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.identifier = UpdateWebPage.super.identifier();
    }

    private ImmutableUpdateWebPage(Builder builder) {
        this.webpage = builder.webpage;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateWebPage.super.identifier();
    }

    private ImmutableUpdateWebPage(int identifier, WebPage webpage, int pts, int ptsCount) {
        this.identifier = identifier;
        this.webpage = webpage;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public WebPage webpage() {
        return this.webpage;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateWebPage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateWebPage(value, this.webpage, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateWebPage withWebpage(WebPage value) {
        if (this.webpage == value) {
            return this;
        }
        WebPage newValue = Objects.requireNonNull(value, "webpage");
        return new ImmutableUpdateWebPage(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateWebPage withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateWebPage(this.identifier, this.webpage, value, this.ptsCount);
    }

    public final ImmutableUpdateWebPage withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateWebPage(this.identifier, this.webpage, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateWebPage && this.equalTo(0, (ImmutableUpdateWebPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateWebPage another) {
        return this.identifier == another.identifier && this.webpage.equals(another.webpage) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.webpage.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateWebPage{identifier=" + this.identifier + ", webpage=" + this.webpage + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateWebPage of(WebPage webpage, int pts, int ptsCount) {
        return new ImmutableUpdateWebPage(webpage, pts, ptsCount);
    }

    public static ImmutableUpdateWebPage copyOf(UpdateWebPage instance) {
        if (instance instanceof ImmutableUpdateWebPage) {
            return (ImmutableUpdateWebPage)instance;
        }
        return ImmutableUpdateWebPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WEBPAGE = 1L;
        private static final long INIT_BIT_PTS = 2L;
        private static final long INIT_BIT_PTS_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private WebPage webpage;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateWebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateWebPage) {
                instance = (UpdateWebPage)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpage(instance.webpage());
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder webpage(WebPage webpage) {
            this.webpage = Objects.requireNonNull(webpage, "webpage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateWebPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateWebPage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("webpage");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateWebPage, some of required attributes are not set " + attributes;
        }
    }
}

