/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateWebViewResultSent;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateWebViewResultSent
implements UpdateWebViewResultSent {
    private final int identifier;
    private final long queryId;

    private ImmutableUpdateWebViewResultSent(long queryId) {
        this.queryId = queryId;
        this.identifier = UpdateWebViewResultSent.super.identifier();
    }

    private ImmutableUpdateWebViewResultSent(Builder builder) {
        this.queryId = builder.queryId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateWebViewResultSent.super.identifier();
    }

    private ImmutableUpdateWebViewResultSent(int identifier, long queryId) {
        this.identifier = identifier;
        this.queryId = queryId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    public final ImmutableUpdateWebViewResultSent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateWebViewResultSent(value, this.queryId);
    }

    public final ImmutableUpdateWebViewResultSent withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateWebViewResultSent(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateWebViewResultSent && this.equalTo(0, (ImmutableUpdateWebViewResultSent)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateWebViewResultSent another) {
        return this.identifier == another.identifier && this.queryId == another.queryId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.queryId);
        return h;
    }

    public String toString() {
        return "UpdateWebViewResultSent{identifier=" + this.identifier + ", queryId=" + this.queryId + "}";
    }

    public static ImmutableUpdateWebViewResultSent of(long queryId) {
        return new ImmutableUpdateWebViewResultSent(queryId);
    }

    public static ImmutableUpdateWebViewResultSent copyOf(UpdateWebViewResultSent instance) {
        if (instance instanceof ImmutableUpdateWebViewResultSent) {
            return (ImmutableUpdateWebViewResultSent)instance;
        }
        return ImmutableUpdateWebViewResultSent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long queryId;

        private Builder() {
        }

        public final Builder from(UpdateWebViewResultSent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateWebViewResultSent) {
                instance = (UpdateWebViewResultSent)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.queryId(instance.queryId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateWebViewResultSent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateWebViewResultSent(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            return "Cannot build UpdateWebViewResultSent, some of required attributes are not set " + attributes;
        }
    }
}

