/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.UrlAuthResult;
import telegram4j.tl.UrlAuthResultAccepted;
import telegram4j.tl.api.TlObject;

public final class ImmutableUrlAuthResultAccepted
implements UrlAuthResultAccepted {
    private final int identifier;
    private final String url;

    private ImmutableUrlAuthResultAccepted(String url) {
        this.url = Objects.requireNonNull(url, "url");
        this.identifier = UrlAuthResultAccepted.super.identifier();
    }

    private ImmutableUrlAuthResultAccepted(Builder builder) {
        this.url = builder.url;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UrlAuthResultAccepted.super.identifier();
    }

    private ImmutableUrlAuthResultAccepted(int identifier, String url) {
        this.identifier = identifier;
        this.url = url;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableUrlAuthResultAccepted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUrlAuthResultAccepted(value, this.url);
    }

    public final ImmutableUrlAuthResultAccepted withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableUrlAuthResultAccepted(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUrlAuthResultAccepted && this.equalTo(0, (ImmutableUrlAuthResultAccepted)another);
    }

    private boolean equalTo(int synthetic, ImmutableUrlAuthResultAccepted another) {
        return this.identifier == another.identifier && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "UrlAuthResultAccepted{identifier=" + this.identifier + ", url=" + this.url + "}";
    }

    public static ImmutableUrlAuthResultAccepted of(String url) {
        return new ImmutableUrlAuthResultAccepted(url);
    }

    public static ImmutableUrlAuthResultAccepted copyOf(UrlAuthResultAccepted instance) {
        if (instance instanceof ImmutableUrlAuthResultAccepted) {
            return (ImmutableUrlAuthResultAccepted)instance;
        }
        return ImmutableUrlAuthResultAccepted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String url;

        private Builder() {
        }

        public final Builder from(UrlAuthResultAccepted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UrlAuthResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UrlAuthResult instance;
            long bits = 0L;
            if (object instanceof UrlAuthResultAccepted) {
                instance = (UrlAuthResultAccepted)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UrlAuthResult) {
                instance = (UrlAuthResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUrlAuthResultAccepted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUrlAuthResultAccepted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build UrlAuthResultAccepted, some of required attributes are not set " + attributes;
        }
    }
}

