/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.UrlAuthResult;
import telegram4j.tl.UrlAuthResultDefault;
import telegram4j.tl.api.TlObject;

public final class ImmutableUrlAuthResultDefault
implements UrlAuthResultDefault {
    private final int identifier;
    private static final ImmutableUrlAuthResultDefault INSTANCE = ImmutableUrlAuthResultDefault.validate(new ImmutableUrlAuthResultDefault());

    private ImmutableUrlAuthResultDefault() {
        this.identifier = UrlAuthResultDefault.super.identifier();
    }

    private ImmutableUrlAuthResultDefault(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UrlAuthResultDefault.super.identifier();
    }

    private ImmutableUrlAuthResultDefault(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUrlAuthResultDefault withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUrlAuthResultDefault.validate(new ImmutableUrlAuthResultDefault(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUrlAuthResultDefault && this.equalTo(0, (ImmutableUrlAuthResultDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableUrlAuthResultDefault another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UrlAuthResultDefault{identifier=" + this.identifier + "}";
    }

    public static ImmutableUrlAuthResultDefault of() {
        return INSTANCE;
    }

    private static ImmutableUrlAuthResultDefault validate(ImmutableUrlAuthResultDefault instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUrlAuthResultDefault copyOf(UrlAuthResultDefault instance) {
        if (instance instanceof ImmutableUrlAuthResultDefault) {
            return (ImmutableUrlAuthResultDefault)instance;
        }
        return ImmutableUrlAuthResultDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UrlAuthResultDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UrlAuthResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UrlAuthResult instance;
            long bits = 0L;
            if (object instanceof UrlAuthResultDefault) {
                instance = (UrlAuthResultDefault)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UrlAuthResult) {
                instance = (UrlAuthResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUrlAuthResultDefault build() {
            return ImmutableUrlAuthResultDefault.validate(new ImmutableUrlAuthResultDefault(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

