/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotInfo;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.PeerSettings;
import telegram4j.tl.Photo;
import telegram4j.tl.PremiumGiftOption;
import telegram4j.tl.UserFull;
import telegram4j.tl.api.TlObject;

public final class ImmutableUserFull
implements UserFull {
    private final int identifier;
    private final int flags;
    private final boolean blocked;
    private final boolean phoneCallsAvailable;
    private final boolean phoneCallsPrivate;
    private final boolean canPinMessage;
    private final boolean hasScheduled;
    private final boolean videoCallsAvailable;
    private final boolean voiceMessagesForbidden;
    private final long id;
    @Nullable
    private final String about;
    private final PeerSettings settings;
    @Nullable
    private final Photo profilePhoto;
    private final PeerNotifySettings notifySettings;
    @Nullable
    private final BotInfo botInfo;
    @Nullable
    private final Integer pinnedMsgId;
    private final int commonChatsCount;
    @Nullable
    private final Integer folderId;
    @Nullable
    private final Integer ttlPeriod;
    @Nullable
    private final String themeEmoticon;
    @Nullable
    private final String privateForwardName;
    @Nullable
    private final ChatAdminRights botGroupAdminRights;
    @Nullable
    private final ChatAdminRights botBroadcastAdminRights;
    @Nullable
    private final List<PremiumGiftOption> premiumGifts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUserFull(long id, PeerSettings settings, PeerNotifySettings notifySettings, int commonChatsCount) {
        this.id = id;
        this.settings = Objects.requireNonNull(settings, "settings");
        this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
        this.commonChatsCount = commonChatsCount;
        this.about = null;
        this.profilePhoto = null;
        this.botInfo = null;
        this.pinnedMsgId = null;
        this.folderId = null;
        this.ttlPeriod = null;
        this.themeEmoticon = null;
        this.privateForwardName = null;
        this.botGroupAdminRights = null;
        this.botBroadcastAdminRights = null;
        this.premiumGifts = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.blocked = this.initShim.blocked();
        this.phoneCallsAvailable = this.initShim.phoneCallsAvailable();
        this.phoneCallsPrivate = this.initShim.phoneCallsPrivate();
        this.canPinMessage = this.initShim.canPinMessage();
        this.hasScheduled = this.initShim.hasScheduled();
        this.videoCallsAvailable = this.initShim.videoCallsAvailable();
        this.voiceMessagesForbidden = this.initShim.voiceMessagesForbidden();
        this.initShim = null;
    }

    private ImmutableUserFull(Builder builder) {
        this.id = builder.id;
        this.about = builder.about;
        this.settings = builder.settings;
        this.profilePhoto = builder.profilePhoto;
        this.notifySettings = builder.notifySettings;
        this.botInfo = builder.botInfo;
        this.pinnedMsgId = builder.pinnedMsgId;
        this.commonChatsCount = builder.commonChatsCount;
        this.folderId = builder.folderId;
        this.ttlPeriod = builder.ttlPeriod;
        this.themeEmoticon = builder.themeEmoticon;
        this.privateForwardName = builder.privateForwardName;
        this.botGroupAdminRights = builder.botGroupAdminRights;
        this.botBroadcastAdminRights = builder.botBroadcastAdminRights;
        List<PremiumGiftOption> list = this.premiumGifts = builder.premiumGifts == null ? null : ImmutableUserFull.createUnmodifiableList(true, builder.premiumGifts);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.blockedIsSet()) {
            this.initShim.blocked(builder.blocked);
        }
        if (builder.phoneCallsAvailableIsSet()) {
            this.initShim.phoneCallsAvailable(builder.phoneCallsAvailable);
        }
        if (builder.phoneCallsPrivateIsSet()) {
            this.initShim.phoneCallsPrivate(builder.phoneCallsPrivate);
        }
        if (builder.canPinMessageIsSet()) {
            this.initShim.canPinMessage(builder.canPinMessage);
        }
        if (builder.hasScheduledIsSet()) {
            this.initShim.hasScheduled(builder.hasScheduled);
        }
        if (builder.videoCallsAvailableIsSet()) {
            this.initShim.videoCallsAvailable(builder.videoCallsAvailable);
        }
        if (builder.voiceMessagesForbiddenIsSet()) {
            this.initShim.voiceMessagesForbidden(builder.voiceMessagesForbidden);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.blocked = this.initShim.blocked();
        this.phoneCallsAvailable = this.initShim.phoneCallsAvailable();
        this.phoneCallsPrivate = this.initShim.phoneCallsPrivate();
        this.canPinMessage = this.initShim.canPinMessage();
        this.hasScheduled = this.initShim.hasScheduled();
        this.videoCallsAvailable = this.initShim.videoCallsAvailable();
        this.voiceMessagesForbidden = this.initShim.voiceMessagesForbidden();
        this.initShim = null;
    }

    private ImmutableUserFull(int identifier, int flags, boolean blocked, boolean phoneCallsAvailable, boolean phoneCallsPrivate, boolean canPinMessage, boolean hasScheduled, boolean videoCallsAvailable, boolean voiceMessagesForbidden, long id, @Nullable String about, PeerSettings settings, @Nullable Photo profilePhoto, PeerNotifySettings notifySettings, @Nullable BotInfo botInfo, @Nullable Integer pinnedMsgId, int commonChatsCount, @Nullable Integer folderId, @Nullable Integer ttlPeriod, @Nullable String themeEmoticon, @Nullable String privateForwardName, @Nullable ChatAdminRights botGroupAdminRights, @Nullable ChatAdminRights botBroadcastAdminRights, @Nullable List<PremiumGiftOption> premiumGifts) {
        this.identifier = identifier;
        this.flags = flags;
        this.blocked = blocked;
        this.phoneCallsAvailable = phoneCallsAvailable;
        this.phoneCallsPrivate = phoneCallsPrivate;
        this.canPinMessage = canPinMessage;
        this.hasScheduled = hasScheduled;
        this.videoCallsAvailable = videoCallsAvailable;
        this.voiceMessagesForbidden = voiceMessagesForbidden;
        this.id = id;
        this.about = about;
        this.settings = settings;
        this.profilePhoto = profilePhoto;
        this.notifySettings = notifySettings;
        this.botInfo = botInfo;
        this.pinnedMsgId = pinnedMsgId;
        this.commonChatsCount = commonChatsCount;
        this.folderId = folderId;
        this.ttlPeriod = ttlPeriod;
        this.themeEmoticon = themeEmoticon;
        this.privateForwardName = privateForwardName;
        this.botGroupAdminRights = botGroupAdminRights;
        this.botBroadcastAdminRights = botBroadcastAdminRights;
        this.premiumGifts = premiumGifts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UserFull.super.identifier();
    }

    private int flagsInitialize() {
        return UserFull.super.flags();
    }

    private boolean blockedInitialize() {
        return UserFull.super.blocked();
    }

    private boolean phoneCallsAvailableInitialize() {
        return UserFull.super.phoneCallsAvailable();
    }

    private boolean phoneCallsPrivateInitialize() {
        return UserFull.super.phoneCallsPrivate();
    }

    private boolean canPinMessageInitialize() {
        return UserFull.super.canPinMessage();
    }

    private boolean hasScheduledInitialize() {
        return UserFull.super.hasScheduled();
    }

    private boolean videoCallsAvailableInitialize() {
        return UserFull.super.videoCallsAvailable();
    }

    private boolean voiceMessagesForbiddenInitialize() {
        return UserFull.super.voiceMessagesForbidden();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean blocked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.blocked() : this.blocked;
    }

    @Override
    public boolean phoneCallsAvailable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phoneCallsAvailable() : this.phoneCallsAvailable;
    }

    @Override
    public boolean phoneCallsPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phoneCallsPrivate() : this.phoneCallsPrivate;
    }

    @Override
    public boolean canPinMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canPinMessage() : this.canPinMessage;
    }

    @Override
    public boolean hasScheduled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasScheduled() : this.hasScheduled;
    }

    @Override
    public boolean videoCallsAvailable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.videoCallsAvailable() : this.videoCallsAvailable;
    }

    @Override
    public boolean voiceMessagesForbidden() {
        InitShim shim = this.initShim;
        return shim != null ? shim.voiceMessagesForbidden() : this.voiceMessagesForbidden;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    @Nullable
    public String about() {
        return this.about;
    }

    @Override
    public PeerSettings settings() {
        return this.settings;
    }

    @Override
    @Nullable
    public Photo profilePhoto() {
        return this.profilePhoto;
    }

    @Override
    public PeerNotifySettings notifySettings() {
        return this.notifySettings;
    }

    @Override
    @Nullable
    public BotInfo botInfo() {
        return this.botInfo;
    }

    @Override
    @Nullable
    public Integer pinnedMsgId() {
        return this.pinnedMsgId;
    }

    @Override
    public int commonChatsCount() {
        return this.commonChatsCount;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    @Override
    @Nullable
    public String themeEmoticon() {
        return this.themeEmoticon;
    }

    @Override
    @Nullable
    public String privateForwardName() {
        return this.privateForwardName;
    }

    @Override
    @Nullable
    public ChatAdminRights botGroupAdminRights() {
        return this.botGroupAdminRights;
    }

    @Override
    @Nullable
    public ChatAdminRights botBroadcastAdminRights() {
        return this.botBroadcastAdminRights;
    }

    @Override
    @Nullable
    public List<PremiumGiftOption> premiumGifts() {
        return this.premiumGifts;
    }

    public final ImmutableUserFull withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUserFull(value, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, value, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withBlocked(boolean value) {
        if (this.blocked == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, value, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withPhoneCallsAvailable(boolean value) {
        if (this.phoneCallsAvailable == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, value, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withPhoneCallsPrivate(boolean value) {
        if (this.phoneCallsPrivate == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, value, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withCanPinMessage(boolean value) {
        if (this.canPinMessage == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, value, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withHasScheduled(boolean value) {
        if (this.hasScheduled == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, value, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withVideoCallsAvailable(boolean value) {
        if (this.videoCallsAvailable == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, value, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withVoiceMessagesForbidden(boolean value) {
        if (this.voiceMessagesForbidden == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, value, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, value, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withAbout(@Nullable String value) {
        if (Objects.equals(this.about, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, value, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withSettings(PeerSettings value) {
        if (this.settings == value) {
            return this;
        }
        PeerSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, newValue, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withProfilePhoto(@Nullable Photo value) {
        if (this.profilePhoto == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, value, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withNotifySettings(PeerNotifySettings value) {
        if (this.notifySettings == value) {
            return this;
        }
        PeerNotifySettings newValue = Objects.requireNonNull(value, "notifySettings");
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, newValue, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withBotInfo(@Nullable BotInfo value) {
        if (this.botInfo == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, value, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withPinnedMsgId(@Nullable Integer value) {
        if (Objects.equals(this.pinnedMsgId, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, value, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withCommonChatsCount(int value) {
        if (this.commonChatsCount == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, value, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, value, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, value, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withThemeEmoticon(@Nullable String value) {
        if (Objects.equals(this.themeEmoticon, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, value, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withPrivateForwardName(@Nullable String value) {
        if (Objects.equals(this.privateForwardName, value)) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, value, this.botGroupAdminRights, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withBotGroupAdminRights(@Nullable ChatAdminRights value) {
        if (this.botGroupAdminRights == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, value, this.botBroadcastAdminRights, this.premiumGifts);
    }

    public final ImmutableUserFull withBotBroadcastAdminRights(@Nullable ChatAdminRights value) {
        if (this.botBroadcastAdminRights == value) {
            return this;
        }
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, value, this.premiumGifts);
    }

    public final ImmutableUserFull withPremiumGifts(PremiumGiftOption ... elements) {
        if (elements == null) {
            return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, null);
        }
        List<PremiumGiftOption> newValue = Arrays.asList(elements) == null ? null : ImmutableUserFull.createUnmodifiableList(false, ImmutableUserFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, newValue);
    }

    public final ImmutableUserFull withPremiumGifts(@Nullable Iterable<? extends PremiumGiftOption> elements) {
        if (this.premiumGifts == elements) {
            return this;
        }
        List<PremiumGiftOption> newValue = elements == null ? null : ImmutableUserFull.createUnmodifiableList(false, ImmutableUserFull.createSafeList(elements, true, false));
        return new ImmutableUserFull(this.identifier, this.flags, this.blocked, this.phoneCallsAvailable, this.phoneCallsPrivate, this.canPinMessage, this.hasScheduled, this.videoCallsAvailable, this.voiceMessagesForbidden, this.id, this.about, this.settings, this.profilePhoto, this.notifySettings, this.botInfo, this.pinnedMsgId, this.commonChatsCount, this.folderId, this.ttlPeriod, this.themeEmoticon, this.privateForwardName, this.botGroupAdminRights, this.botBroadcastAdminRights, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserFull && this.equalTo(0, (ImmutableUserFull)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserFull another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.blocked == another.blocked && this.phoneCallsAvailable == another.phoneCallsAvailable && this.phoneCallsPrivate == another.phoneCallsPrivate && this.canPinMessage == another.canPinMessage && this.hasScheduled == another.hasScheduled && this.videoCallsAvailable == another.videoCallsAvailable && this.voiceMessagesForbidden == another.voiceMessagesForbidden && this.id == another.id && Objects.equals(this.about, another.about) && this.settings.equals(another.settings) && Objects.equals(this.profilePhoto, another.profilePhoto) && this.notifySettings.equals(another.notifySettings) && Objects.equals(this.botInfo, another.botInfo) && Objects.equals(this.pinnedMsgId, another.pinnedMsgId) && this.commonChatsCount == another.commonChatsCount && Objects.equals(this.folderId, another.folderId) && Objects.equals(this.ttlPeriod, another.ttlPeriod) && Objects.equals(this.themeEmoticon, another.themeEmoticon) && Objects.equals(this.privateForwardName, another.privateForwardName) && Objects.equals(this.botGroupAdminRights, another.botGroupAdminRights) && Objects.equals(this.botBroadcastAdminRights, another.botBroadcastAdminRights) && Objects.equals(this.premiumGifts, another.premiumGifts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.blocked);
        h += (h << 5) + Boolean.hashCode(this.phoneCallsAvailable);
        h += (h << 5) + Boolean.hashCode(this.phoneCallsPrivate);
        h += (h << 5) + Boolean.hashCode(this.canPinMessage);
        h += (h << 5) + Boolean.hashCode(this.hasScheduled);
        h += (h << 5) + Boolean.hashCode(this.videoCallsAvailable);
        h += (h << 5) + Boolean.hashCode(this.voiceMessagesForbidden);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.about);
        h += (h << 5) + this.settings.hashCode();
        h += (h << 5) + Objects.hashCode(this.profilePhoto);
        h += (h << 5) + this.notifySettings.hashCode();
        h += (h << 5) + Objects.hashCode(this.botInfo);
        h += (h << 5) + Objects.hashCode(this.pinnedMsgId);
        h += (h << 5) + this.commonChatsCount;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        h += (h << 5) + Objects.hashCode(this.themeEmoticon);
        h += (h << 5) + Objects.hashCode(this.privateForwardName);
        h += (h << 5) + Objects.hashCode(this.botGroupAdminRights);
        h += (h << 5) + Objects.hashCode(this.botBroadcastAdminRights);
        h += (h << 5) + Objects.hashCode(this.premiumGifts);
        return h;
    }

    public String toString() {
        return "UserFull{identifier=" + this.identifier + ", flags=" + this.flags + ", blocked=" + this.blocked + ", phoneCallsAvailable=" + this.phoneCallsAvailable + ", phoneCallsPrivate=" + this.phoneCallsPrivate + ", canPinMessage=" + this.canPinMessage + ", hasScheduled=" + this.hasScheduled + ", videoCallsAvailable=" + this.videoCallsAvailable + ", voiceMessagesForbidden=" + this.voiceMessagesForbidden + ", id=" + this.id + ", about=" + this.about + ", settings=" + this.settings + ", profilePhoto=" + this.profilePhoto + ", notifySettings=" + this.notifySettings + ", botInfo=" + this.botInfo + ", pinnedMsgId=" + this.pinnedMsgId + ", commonChatsCount=" + this.commonChatsCount + ", folderId=" + this.folderId + ", ttlPeriod=" + this.ttlPeriod + ", themeEmoticon=" + this.themeEmoticon + ", privateForwardName=" + this.privateForwardName + ", botGroupAdminRights=" + this.botGroupAdminRights + ", botBroadcastAdminRights=" + this.botBroadcastAdminRights + ", premiumGifts=" + this.premiumGifts + "}";
    }

    public static ImmutableUserFull of(long id, PeerSettings settings, PeerNotifySettings notifySettings, int commonChatsCount) {
        return new ImmutableUserFull(id, settings, notifySettings, commonChatsCount);
    }

    public static ImmutableUserFull copyOf(UserFull instance) {
        if (instance instanceof ImmutableUserFull) {
            return (ImmutableUserFull)instance;
        }
        return ImmutableUserFull.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long INIT_BIT_NOTIFY_SETTINGS = 4L;
        private static final long INIT_BIT_COMMON_CHATS_COUNT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BLOCKED = 4L;
        private static final long OPT_BIT_PHONE_CALLS_AVAILABLE = 8L;
        private static final long OPT_BIT_PHONE_CALLS_PRIVATE = 16L;
        private static final long OPT_BIT_CAN_PIN_MESSAGE = 32L;
        private static final long OPT_BIT_HAS_SCHEDULED = 64L;
        private static final long OPT_BIT_VIDEO_CALLS_AVAILABLE = 128L;
        private static final long OPT_BIT_VOICE_MESSAGES_FORBIDDEN = 256L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean blocked;
        private boolean phoneCallsAvailable;
        private boolean phoneCallsPrivate;
        private boolean canPinMessage;
        private boolean hasScheduled;
        private boolean videoCallsAvailable;
        private boolean voiceMessagesForbidden;
        private long id;
        private String about;
        private PeerSettings settings;
        private Photo profilePhoto;
        private PeerNotifySettings notifySettings;
        private BotInfo botInfo;
        private Integer pinnedMsgId;
        private int commonChatsCount;
        private Integer folderId;
        private Integer ttlPeriod;
        private String themeEmoticon;
        private String privateForwardName;
        private ChatAdminRights botGroupAdminRights;
        private ChatAdminRights botBroadcastAdminRights;
        private List<PremiumGiftOption> premiumGifts = null;

        private Builder() {
        }

        public final Builder from(UserFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserFull instance;
            long bits = 0L;
            if (object instanceof UserFull) {
                ChatAdminRights botGroupAdminRightsValue;
                Integer ttlPeriodValue;
                String privateForwardNameValue;
                String themeEmoticonValue;
                Integer pinnedMsgIdValue;
                BotInfo botInfoValue;
                instance = (UserFull)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.commonChatsCount(instance.commonChatsCount());
                this.phoneCallsAvailable(instance.phoneCallsAvailable());
                ChatAdminRights botBroadcastAdminRightsValue = instance.botBroadcastAdminRights();
                if (botBroadcastAdminRightsValue != null) {
                    this.botBroadcastAdminRights(botBroadcastAdminRightsValue);
                }
                if ((botInfoValue = instance.botInfo()) != null) {
                    this.botInfo(botInfoValue);
                }
                if ((pinnedMsgIdValue = instance.pinnedMsgId()) != null) {
                    this.pinnedMsgId(pinnedMsgIdValue);
                }
                this.flags(instance.flags());
                String aboutValue = instance.about();
                if (aboutValue != null) {
                    this.about(aboutValue);
                }
                this.phoneCallsPrivate(instance.phoneCallsPrivate());
                this.canPinMessage(instance.canPinMessage());
                this.notifySettings(instance.notifySettings());
                Integer folderIdValue = instance.folderId();
                if (folderIdValue != null) {
                    this.folderId(folderIdValue);
                }
                if ((themeEmoticonValue = instance.themeEmoticon()) != null) {
                    this.themeEmoticon(themeEmoticonValue);
                }
                this.voiceMessagesForbidden(instance.voiceMessagesForbidden());
                Photo profilePhotoValue = instance.profilePhoto();
                if (profilePhotoValue != null) {
                    this.profilePhoto(profilePhotoValue);
                }
                if ((privateForwardNameValue = instance.privateForwardName()) != null) {
                    this.privateForwardName(privateForwardNameValue);
                }
                this.blocked(instance.blocked());
                this.videoCallsAvailable(instance.videoCallsAvailable());
                List<PremiumGiftOption> premiumGiftsValue = instance.premiumGifts();
                if (premiumGiftsValue != null) {
                    this.addAllPremiumGifts(premiumGiftsValue);
                }
                if ((ttlPeriodValue = instance.ttlPeriod()) != null) {
                    this.ttlPeriod(ttlPeriodValue);
                }
                if ((botGroupAdminRightsValue = instance.botGroupAdminRights()) != null) {
                    this.botGroupAdminRights(botGroupAdminRightsValue);
                }
                this.id(instance.id());
                this.hasScheduled(instance.hasScheduled());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder blocked(boolean blocked) {
            this.blocked = blocked;
            this.optBits |= 4L;
            return this;
        }

        public final Builder phoneCallsAvailable(boolean phoneCallsAvailable) {
            this.phoneCallsAvailable = phoneCallsAvailable;
            this.optBits |= 8L;
            return this;
        }

        public final Builder phoneCallsPrivate(boolean phoneCallsPrivate) {
            this.phoneCallsPrivate = phoneCallsPrivate;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder canPinMessage(boolean canPinMessage) {
            this.canPinMessage = canPinMessage;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder videoCallsAvailable(boolean videoCallsAvailable) {
            this.videoCallsAvailable = videoCallsAvailable;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder voiceMessagesForbidden(boolean voiceMessagesForbidden) {
            this.voiceMessagesForbidden = voiceMessagesForbidden;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder about(@Nullable String about) {
            this.about = about;
            return this;
        }

        public final Builder settings(PeerSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder profilePhoto(@Nullable Photo profilePhoto) {
            this.profilePhoto = profilePhoto;
            return this;
        }

        public final Builder notifySettings(PeerNotifySettings notifySettings) {
            this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder botInfo(@Nullable BotInfo botInfo) {
            this.botInfo = botInfo;
            return this;
        }

        public final Builder pinnedMsgId(@Nullable Integer pinnedMsgId) {
            this.pinnedMsgId = pinnedMsgId;
            return this;
        }

        public final Builder commonChatsCount(int commonChatsCount) {
            this.commonChatsCount = commonChatsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public final Builder themeEmoticon(@Nullable String themeEmoticon) {
            this.themeEmoticon = themeEmoticon;
            return this;
        }

        public final Builder privateForwardName(@Nullable String privateForwardName) {
            this.privateForwardName = privateForwardName;
            return this;
        }

        public final Builder botGroupAdminRights(@Nullable ChatAdminRights botGroupAdminRights) {
            this.botGroupAdminRights = botGroupAdminRights;
            return this;
        }

        public final Builder botBroadcastAdminRights(@Nullable ChatAdminRights botBroadcastAdminRights) {
            this.botBroadcastAdminRights = botBroadcastAdminRights;
            return this;
        }

        public final Builder addPremiumGift(PremiumGiftOption element) {
            if (this.premiumGifts == null) {
                this.premiumGifts = new ArrayList<PremiumGiftOption>();
            }
            this.premiumGifts.add(Objects.requireNonNull(element, "premiumGifts element"));
            return this;
        }

        public final Builder addPremiumGifts(PremiumGiftOption ... elements) {
            if (this.premiumGifts == null) {
                this.premiumGifts = new ArrayList<PremiumGiftOption>();
            }
            for (PremiumGiftOption element : elements) {
                this.premiumGifts.add(Objects.requireNonNull(element, "premiumGifts element"));
            }
            return this;
        }

        public final Builder premiumGifts(@Nullable Iterable<? extends PremiumGiftOption> elements) {
            if (elements == null) {
                this.premiumGifts = null;
                return this;
            }
            this.premiumGifts = new ArrayList<PremiumGiftOption>();
            return this.addAllPremiumGifts(elements);
        }

        public final Builder addAllPremiumGifts(Iterable<? extends PremiumGiftOption> elements) {
            Objects.requireNonNull(elements, "premiumGifts element");
            if (this.premiumGifts == null) {
                this.premiumGifts = new ArrayList<PremiumGiftOption>();
            }
            for (PremiumGiftOption premiumGiftOption : elements) {
                this.premiumGifts.add(Objects.requireNonNull(premiumGiftOption, "premiumGifts element"));
            }
            return this;
        }

        public ImmutableUserFull build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserFull(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean blockedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean phoneCallsAvailableIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean phoneCallsPrivateIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean canPinMessageIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean hasScheduledIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean videoCallsAvailableIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean voiceMessagesForbiddenIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("notifySettings");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("commonChatsCount");
            }
            return "Cannot build UserFull, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte blockedBuildStage = 0;
        private boolean blocked;
        private byte phoneCallsAvailableBuildStage = 0;
        private boolean phoneCallsAvailable;
        private byte phoneCallsPrivateBuildStage = 0;
        private boolean phoneCallsPrivate;
        private byte canPinMessageBuildStage = 0;
        private boolean canPinMessage;
        private byte hasScheduledBuildStage = 0;
        private boolean hasScheduled;
        private byte videoCallsAvailableBuildStage = 0;
        private boolean videoCallsAvailable;
        private byte voiceMessagesForbiddenBuildStage = 0;
        private boolean voiceMessagesForbidden;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUserFull.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUserFull.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean blocked() {
            if (this.blockedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.blockedBuildStage == 0) {
                this.blockedBuildStage = (byte)-1;
                this.blocked = ImmutableUserFull.this.blockedInitialize();
                this.blockedBuildStage = 1;
            }
            return this.blocked;
        }

        void blocked(boolean blocked) {
            this.blocked = blocked;
            this.blockedBuildStage = 1;
        }

        boolean phoneCallsAvailable() {
            if (this.phoneCallsAvailableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phoneCallsAvailableBuildStage == 0) {
                this.phoneCallsAvailableBuildStage = (byte)-1;
                this.phoneCallsAvailable = ImmutableUserFull.this.phoneCallsAvailableInitialize();
                this.phoneCallsAvailableBuildStage = 1;
            }
            return this.phoneCallsAvailable;
        }

        void phoneCallsAvailable(boolean phoneCallsAvailable) {
            this.phoneCallsAvailable = phoneCallsAvailable;
            this.phoneCallsAvailableBuildStage = 1;
        }

        boolean phoneCallsPrivate() {
            if (this.phoneCallsPrivateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phoneCallsPrivateBuildStage == 0) {
                this.phoneCallsPrivateBuildStage = (byte)-1;
                this.phoneCallsPrivate = ImmutableUserFull.this.phoneCallsPrivateInitialize();
                this.phoneCallsPrivateBuildStage = 1;
            }
            return this.phoneCallsPrivate;
        }

        void phoneCallsPrivate(boolean phoneCallsPrivate) {
            this.phoneCallsPrivate = phoneCallsPrivate;
            this.phoneCallsPrivateBuildStage = 1;
        }

        boolean canPinMessage() {
            if (this.canPinMessageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canPinMessageBuildStage == 0) {
                this.canPinMessageBuildStage = (byte)-1;
                this.canPinMessage = ImmutableUserFull.this.canPinMessageInitialize();
                this.canPinMessageBuildStage = 1;
            }
            return this.canPinMessage;
        }

        void canPinMessage(boolean canPinMessage) {
            this.canPinMessage = canPinMessage;
            this.canPinMessageBuildStage = 1;
        }

        boolean hasScheduled() {
            if (this.hasScheduledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasScheduledBuildStage == 0) {
                this.hasScheduledBuildStage = (byte)-1;
                this.hasScheduled = ImmutableUserFull.this.hasScheduledInitialize();
                this.hasScheduledBuildStage = 1;
            }
            return this.hasScheduled;
        }

        void hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.hasScheduledBuildStage = 1;
        }

        boolean videoCallsAvailable() {
            if (this.videoCallsAvailableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoCallsAvailableBuildStage == 0) {
                this.videoCallsAvailableBuildStage = (byte)-1;
                this.videoCallsAvailable = ImmutableUserFull.this.videoCallsAvailableInitialize();
                this.videoCallsAvailableBuildStage = 1;
            }
            return this.videoCallsAvailable;
        }

        void videoCallsAvailable(boolean videoCallsAvailable) {
            this.videoCallsAvailable = videoCallsAvailable;
            this.videoCallsAvailableBuildStage = 1;
        }

        boolean voiceMessagesForbidden() {
            if (this.voiceMessagesForbiddenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.voiceMessagesForbiddenBuildStage == 0) {
                this.voiceMessagesForbiddenBuildStage = (byte)-1;
                this.voiceMessagesForbidden = ImmutableUserFull.this.voiceMessagesForbiddenInitialize();
                this.voiceMessagesForbiddenBuildStage = 1;
            }
            return this.voiceMessagesForbidden;
        }

        void voiceMessagesForbidden(boolean voiceMessagesForbidden) {
            this.voiceMessagesForbidden = voiceMessagesForbidden;
            this.voiceMessagesForbiddenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.blockedBuildStage == -1) {
                attributes.add("blocked");
            }
            if (this.phoneCallsAvailableBuildStage == -1) {
                attributes.add("phoneCallsAvailable");
            }
            if (this.phoneCallsPrivateBuildStage == -1) {
                attributes.add("phoneCallsPrivate");
            }
            if (this.canPinMessageBuildStage == -1) {
                attributes.add("canPinMessage");
            }
            if (this.hasScheduledBuildStage == -1) {
                attributes.add("hasScheduled");
            }
            if (this.videoCallsAvailableBuildStage == -1) {
                attributes.add("videoCallsAvailable");
            }
            if (this.voiceMessagesForbiddenBuildStage == -1) {
                attributes.add("voiceMessagesForbidden");
            }
            return "Cannot build UserFull, attribute initializers form cycle " + attributes;
        }
    }
}

