/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.UserStatus;
import telegram4j.tl.UserStatusLastWeek;
import telegram4j.tl.api.TlObject;

public final class ImmutableUserStatusLastWeek
implements UserStatusLastWeek {
    private final int identifier;
    private static final ImmutableUserStatusLastWeek INSTANCE = ImmutableUserStatusLastWeek.validate(new ImmutableUserStatusLastWeek());

    private ImmutableUserStatusLastWeek() {
        this.identifier = UserStatusLastWeek.super.identifier();
    }

    private ImmutableUserStatusLastWeek(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UserStatusLastWeek.super.identifier();
    }

    private ImmutableUserStatusLastWeek(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUserStatusLastWeek withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUserStatusLastWeek.validate(new ImmutableUserStatusLastWeek(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserStatusLastWeek && this.equalTo(0, (ImmutableUserStatusLastWeek)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserStatusLastWeek another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UserStatusLastWeek{identifier=" + this.identifier + "}";
    }

    public static ImmutableUserStatusLastWeek of() {
        return INSTANCE;
    }

    private static ImmutableUserStatusLastWeek validate(ImmutableUserStatusLastWeek instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUserStatusLastWeek copyOf(UserStatusLastWeek instance) {
        if (instance instanceof ImmutableUserStatusLastWeek) {
            return (ImmutableUserStatusLastWeek)instance;
        }
        return ImmutableUserStatusLastWeek.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UserStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserStatusLastWeek instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserStatus instance;
            long bits = 0L;
            if (object instanceof UserStatus) {
                instance = (UserStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UserStatusLastWeek) {
                instance = (UserStatusLastWeek)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUserStatusLastWeek build() {
            return ImmutableUserStatusLastWeek.validate(new ImmutableUserStatusLastWeek(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

