/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.UserStatus;
import telegram4j.tl.UserStatusOffline;
import telegram4j.tl.api.TlObject;

public final class ImmutableUserStatusOffline
implements UserStatusOffline {
    private final int identifier;
    private final int wasOnline;

    private ImmutableUserStatusOffline(int wasOnline) {
        this.wasOnline = wasOnline;
        this.identifier = UserStatusOffline.super.identifier();
    }

    private ImmutableUserStatusOffline(Builder builder) {
        this.wasOnline = builder.wasOnline;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UserStatusOffline.super.identifier();
    }

    private ImmutableUserStatusOffline(int identifier, int wasOnline) {
        this.identifier = identifier;
        this.wasOnline = wasOnline;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int wasOnline() {
        return this.wasOnline;
    }

    public final ImmutableUserStatusOffline withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUserStatusOffline(value, this.wasOnline);
    }

    public final ImmutableUserStatusOffline withWasOnline(int value) {
        if (this.wasOnline == value) {
            return this;
        }
        return new ImmutableUserStatusOffline(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserStatusOffline && this.equalTo(0, (ImmutableUserStatusOffline)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserStatusOffline another) {
        return this.identifier == another.identifier && this.wasOnline == another.wasOnline;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.wasOnline;
        return h;
    }

    public String toString() {
        return "UserStatusOffline{identifier=" + this.identifier + ", wasOnline=" + this.wasOnline + "}";
    }

    public static ImmutableUserStatusOffline of(int wasOnline) {
        return new ImmutableUserStatusOffline(wasOnline);
    }

    public static ImmutableUserStatusOffline copyOf(UserStatusOffline instance) {
        if (instance instanceof ImmutableUserStatusOffline) {
            return (ImmutableUserStatusOffline)instance;
        }
        return ImmutableUserStatusOffline.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WAS_ONLINE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int wasOnline;

        private Builder() {
        }

        public final Builder from(UserStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserStatusOffline instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserStatus instance;
            long bits = 0L;
            if (object instanceof UserStatus) {
                instance = (UserStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UserStatusOffline) {
                instance = (UserStatusOffline)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.wasOnline(instance.wasOnline());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder wasOnline(int wasOnline) {
            this.wasOnline = wasOnline;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUserStatusOffline build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserStatusOffline(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wasOnline");
            }
            return "Cannot build UserStatusOffline, some of required attributes are not set " + attributes;
        }
    }
}

