/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.UserStatus;
import telegram4j.tl.UserStatusOnline;
import telegram4j.tl.api.TlObject;

public final class ImmutableUserStatusOnline
implements UserStatusOnline {
    private final int identifier;
    private final int expires;

    private ImmutableUserStatusOnline(int expires) {
        this.expires = expires;
        this.identifier = UserStatusOnline.super.identifier();
    }

    private ImmutableUserStatusOnline(Builder builder) {
        this.expires = builder.expires;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UserStatusOnline.super.identifier();
    }

    private ImmutableUserStatusOnline(int identifier, int expires) {
        this.identifier = identifier;
        this.expires = expires;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    public final ImmutableUserStatusOnline withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUserStatusOnline(value, this.expires);
    }

    public final ImmutableUserStatusOnline withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableUserStatusOnline(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserStatusOnline && this.equalTo(0, (ImmutableUserStatusOnline)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserStatusOnline another) {
        return this.identifier == another.identifier && this.expires == another.expires;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.expires;
        return h;
    }

    public String toString() {
        return "UserStatusOnline{identifier=" + this.identifier + ", expires=" + this.expires + "}";
    }

    public static ImmutableUserStatusOnline of(int expires) {
        return new ImmutableUserStatusOnline(expires);
    }

    public static ImmutableUserStatusOnline copyOf(UserStatusOnline instance) {
        if (instance instanceof ImmutableUserStatusOnline) {
            return (ImmutableUserStatusOnline)instance;
        }
        return ImmutableUserStatusOnline.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXPIRES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int expires;

        private Builder() {
        }

        public final Builder from(UserStatusOnline instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserStatus instance;
            long bits = 0L;
            if (object instanceof UserStatusOnline) {
                instance = (UserStatusOnline)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.expires(instance.expires());
            }
            if (object instanceof UserStatus) {
                instance = (UserStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUserStatusOnline build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserStatusOnline(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build UserStatusOnline, some of required attributes are not set " + attributes;
        }
    }
}

