/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.UserStatus;
import telegram4j.tl.UserStatusRecently;
import telegram4j.tl.api.TlObject;

public final class ImmutableUserStatusRecently
implements UserStatusRecently {
    private final int identifier;
    private static final ImmutableUserStatusRecently INSTANCE = ImmutableUserStatusRecently.validate(new ImmutableUserStatusRecently());

    private ImmutableUserStatusRecently() {
        this.identifier = UserStatusRecently.super.identifier();
    }

    private ImmutableUserStatusRecently(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UserStatusRecently.super.identifier();
    }

    private ImmutableUserStatusRecently(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUserStatusRecently withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUserStatusRecently.validate(new ImmutableUserStatusRecently(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserStatusRecently && this.equalTo(0, (ImmutableUserStatusRecently)another);
    }

    private boolean equalTo(int synthetic, ImmutableUserStatusRecently another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UserStatusRecently{identifier=" + this.identifier + "}";
    }

    public static ImmutableUserStatusRecently of() {
        return INSTANCE;
    }

    private static ImmutableUserStatusRecently validate(ImmutableUserStatusRecently instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUserStatusRecently copyOf(UserStatusRecently instance) {
        if (instance instanceof ImmutableUserStatusRecently) {
            return (ImmutableUserStatusRecently)instance;
        }
        return ImmutableUserStatusRecently.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UserStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserStatusRecently instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UserStatus instance;
            long bits = 0L;
            if (object instanceof UserStatus) {
                instance = (UserStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UserStatusRecently) {
                instance = (UserStatusRecently)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUserStatusRecently build() {
            return ImmutableUserStatusRecently.validate(new ImmutableUserStatusRecently(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

