/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.VideoSize;
import telegram4j.tl.api.TlObject;

public final class ImmutableVideoSize
implements VideoSize {
    private final int identifier;
    private final int flags;
    private final String type;
    private final int w;
    private final int h;
    private final int size;
    @Nullable
    private final Double videoStartTs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVideoSize(String type, int w, int h, int size) {
        this.type = Objects.requireNonNull(type, "type");
        this.w = w;
        this.h = h;
        this.size = size;
        this.videoStartTs = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableVideoSize(Builder builder) {
        this.type = builder.type;
        this.w = builder.w;
        this.h = builder.h;
        this.size = builder.size;
        this.videoStartTs = builder.videoStartTs;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableVideoSize(int identifier, int flags, String type, int w, int h, int size, @Nullable Double videoStartTs) {
        this.identifier = identifier;
        this.flags = flags;
        this.type = type;
        this.w = w;
        this.h = h;
        this.size = size;
        this.videoStartTs = videoStartTs;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return VideoSize.super.identifier();
    }

    private int flagsInitialize() {
        return VideoSize.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nullable
    public Double videoStartTs() {
        return this.videoStartTs;
    }

    public final ImmutableVideoSize withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableVideoSize(value, this.flags, this.type, this.w, this.h, this.size, this.videoStartTs);
    }

    public final ImmutableVideoSize withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, value, this.type, this.w, this.h, this.size, this.videoStartTs);
    }

    public final ImmutableVideoSize withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, this.flags, newValue, this.w, this.h, this.size, this.videoStartTs);
    }

    public final ImmutableVideoSize withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, this.flags, this.type, value, this.h, this.size, this.videoStartTs);
    }

    public final ImmutableVideoSize withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, this.flags, this.type, this.w, value, this.size, this.videoStartTs);
    }

    public final ImmutableVideoSize withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, this.flags, this.type, this.w, this.h, value, this.videoStartTs);
    }

    public final ImmutableVideoSize withVideoStartTs(@Nullable Double value) {
        if (Objects.equals(this.videoStartTs, value)) {
            return this;
        }
        return new ImmutableVideoSize(this.identifier, this.flags, this.type, this.w, this.h, this.size, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVideoSize && this.equalTo(0, (ImmutableVideoSize)another);
    }

    private boolean equalTo(int synthetic, ImmutableVideoSize another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.type.equals(another.type) && this.w == another.w && this.h == another.h && this.size == another.size && Objects.equals(this.videoStartTs, another.videoStartTs);
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.flags;
        h$$ += (h$$ << 5) + this.type.hashCode();
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.size;
        h$$ += (h$$ << 5) + Objects.hashCode(this.videoStartTs);
        return h$$;
    }

    public String toString() {
        return "VideoSize{identifier=" + this.identifier + ", flags=" + this.flags + ", type=" + this.type + ", w=" + this.w + ", h=" + this.h + ", size=" + this.size + ", videoStartTs=" + this.videoStartTs + "}";
    }

    public static ImmutableVideoSize of(String type, int w, int h, int size) {
        return new ImmutableVideoSize(type, w, h, size);
    }

    public static ImmutableVideoSize copyOf(VideoSize instance) {
        if (instance instanceof ImmutableVideoSize) {
            return (ImmutableVideoSize)instance;
        }
        return ImmutableVideoSize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private String type;
        private int w;
        private int h;
        private int size;
        private Double videoStartTs;

        private Builder() {
        }

        public final Builder from(VideoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            VideoSize instance;
            long bits = 0L;
            if (object instanceof VideoSize) {
                Double videoStartTsValue;
                instance = (VideoSize)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((videoStartTsValue = instance.videoStartTs()) != null) {
                    this.videoStartTs(videoStartTsValue);
                }
                this.size(instance.size());
                this.w(instance.w());
                this.flags(instance.flags());
                this.h(instance.h());
                this.type(instance.type());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder videoStartTs(@Nullable Double videoStartTs) {
            this.videoStartTs = videoStartTs;
            return this;
        }

        public ImmutableVideoSize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVideoSize(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build VideoSize, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableVideoSize.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableVideoSize.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build VideoSize, attribute initializers form cycle " + attributes;
        }
    }
}

