/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.WallPaper;
import telegram4j.tl.WallPaperNoFile;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableWallPaperNoFile
implements WallPaperNoFile {
    private final int identifier;
    private final long id;
    private final int flags;
    private final boolean isDefault;
    private final boolean dark;
    @Nullable
    private final WallPaperSettings settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWallPaperNoFile(long id) {
        this.id = id;
        this.settings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isDefault = this.initShim.isDefault();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableWallPaperNoFile(Builder builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.isDefaultIsSet()) {
            this.initShim.isDefault(builder.isDefault);
        }
        if (builder.darkIsSet()) {
            this.initShim.dark(builder.dark);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.isDefault = this.initShim.isDefault();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableWallPaperNoFile(int identifier, long id, int flags, boolean isDefault, boolean dark, @Nullable WallPaperSettings settings) {
        this.identifier = identifier;
        this.id = id;
        this.flags = flags;
        this.isDefault = isDefault;
        this.dark = dark;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WallPaperNoFile.super.identifier();
    }

    private int flagsInitialize() {
        return WallPaperNoFile.super.flags();
    }

    private boolean isDefaultInitialize() {
        return WallPaperNoFile.super.isDefault();
    }

    private boolean darkInitialize() {
        return WallPaperNoFile.super.dark();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean isDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDefault() : this.isDefault;
    }

    @Override
    public boolean dark() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dark() : this.dark;
    }

    @Override
    @Nullable
    public WallPaperSettings settings() {
        return this.settings;
    }

    public final ImmutableWallPaperNoFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(value, this.id, this.flags, this.isDefault, this.dark, this.settings);
    }

    public final ImmutableWallPaperNoFile withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(this.identifier, value, this.flags, this.isDefault, this.dark, this.settings);
    }

    public final ImmutableWallPaperNoFile withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(this.identifier, this.id, value, this.isDefault, this.dark, this.settings);
    }

    public final ImmutableWallPaperNoFile withIsDefault(boolean value) {
        if (this.isDefault == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(this.identifier, this.id, this.flags, value, this.dark, this.settings);
    }

    public final ImmutableWallPaperNoFile withDark(boolean value) {
        if (this.dark == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(this.identifier, this.id, this.flags, this.isDefault, value, this.settings);
    }

    public final ImmutableWallPaperNoFile withSettings(@Nullable WallPaperSettings value) {
        if (this.settings == value) {
            return this;
        }
        return new ImmutableWallPaperNoFile(this.identifier, this.id, this.flags, this.isDefault, this.dark, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWallPaperNoFile && this.equalTo(0, (ImmutableWallPaperNoFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableWallPaperNoFile another) {
        return this.identifier == another.identifier && this.id == another.id && this.flags == another.flags && this.isDefault == another.isDefault && this.dark == another.dark && Objects.equals(this.settings, another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.isDefault);
        h += (h << 5) + Boolean.hashCode(this.dark);
        h += (h << 5) + Objects.hashCode(this.settings);
        return h;
    }

    public String toString() {
        return "WallPaperNoFile{identifier=" + this.identifier + ", id=" + this.id + ", flags=" + this.flags + ", isDefault=" + this.isDefault + ", dark=" + this.dark + ", settings=" + this.settings + "}";
    }

    public static ImmutableWallPaperNoFile of(long id) {
        return new ImmutableWallPaperNoFile(id);
    }

    public static ImmutableWallPaperNoFile copyOf(WallPaperNoFile instance) {
        if (instance instanceof ImmutableWallPaperNoFile) {
            return (ImmutableWallPaperNoFile)instance;
        }
        return ImmutableWallPaperNoFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IS_DEFAULT = 4L;
        private static final long OPT_BIT_DARK = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long id;
        private int flags;
        private boolean isDefault;
        private boolean dark;
        private WallPaperSettings settings;

        private Builder() {
        }

        public final Builder from(WallPaperNoFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WallPaperSettings settingsValue;
            WallPaper instance;
            long bits = 0L;
            if (object instanceof WallPaperNoFile) {
                instance = (WallPaperNoFile)object;
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.dark(instance.dark());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    settingsValue = instance.settings();
                    if (settingsValue != null) {
                        this.settings(settingsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isDefault(instance.isDefault());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WallPaper) {
                instance = (WallPaper)object;
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.dark(instance.dark());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    settingsValue = instance.settings();
                    if (settingsValue != null) {
                        this.settings(settingsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isDefault(instance.isDefault());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.optBits |= 4L;
            return this;
        }

        public final Builder dark(boolean dark) {
            this.dark = dark;
            this.optBits |= 8L;
            return this;
        }

        public final Builder settings(@Nullable WallPaperSettings settings) {
            this.settings = settings;
            return this;
        }

        public ImmutableWallPaperNoFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWallPaperNoFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isDefaultIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean darkIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build WallPaperNoFile, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte isDefaultBuildStage = 0;
        private boolean isDefault;
        private byte darkBuildStage = 0;
        private boolean dark;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWallPaperNoFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableWallPaperNoFile.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean isDefault() {
            if (this.isDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDefaultBuildStage == 0) {
                this.isDefaultBuildStage = (byte)-1;
                this.isDefault = ImmutableWallPaperNoFile.this.isDefaultInitialize();
                this.isDefaultBuildStage = 1;
            }
            return this.isDefault;
        }

        void isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.isDefaultBuildStage = 1;
        }

        boolean dark() {
            if (this.darkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.darkBuildStage == 0) {
                this.darkBuildStage = (byte)-1;
                this.dark = ImmutableWallPaperNoFile.this.darkInitialize();
                this.darkBuildStage = 1;
            }
            return this.dark;
        }

        void dark(boolean dark) {
            this.dark = dark;
            this.darkBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.isDefaultBuildStage == -1) {
                attributes.add("isDefault");
            }
            if (this.darkBuildStage == -1) {
                attributes.add("dark");
            }
            return "Cannot build WallPaperNoFile, attribute initializers form cycle " + attributes;
        }
    }
}

