/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableWallPaperSettings
implements WallPaperSettings {
    private final int identifier;
    private final int flags;
    private final boolean blur;
    private final boolean motion;
    @Nullable
    private final Integer backgroundColor;
    @Nullable
    private final Integer secondBackgroundColor;
    @Nullable
    private final Integer thirdBackgroundColor;
    @Nullable
    private final Integer fourthBackgroundColor;
    @Nullable
    private final Integer intensity;
    @Nullable
    private final Integer rotation;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableWallPaperSettings INSTANCE = ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings());

    private ImmutableWallPaperSettings() {
        this.backgroundColor = null;
        this.secondBackgroundColor = null;
        this.thirdBackgroundColor = null;
        this.fourthBackgroundColor = null;
        this.intensity = null;
        this.rotation = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.blur = this.initShim.blur();
        this.motion = this.initShim.motion();
        this.initShim = null;
    }

    private ImmutableWallPaperSettings(Builder builder) {
        this.backgroundColor = builder.backgroundColor;
        this.secondBackgroundColor = builder.secondBackgroundColor;
        this.thirdBackgroundColor = builder.thirdBackgroundColor;
        this.fourthBackgroundColor = builder.fourthBackgroundColor;
        this.intensity = builder.intensity;
        this.rotation = builder.rotation;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.blurIsSet()) {
            this.initShim.blur(builder.blur);
        }
        if (builder.motionIsSet()) {
            this.initShim.motion(builder.motion);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.blur = this.initShim.blur();
        this.motion = this.initShim.motion();
        this.initShim = null;
    }

    private ImmutableWallPaperSettings(int identifier, int flags, boolean blur, boolean motion, @Nullable Integer backgroundColor, @Nullable Integer secondBackgroundColor, @Nullable Integer thirdBackgroundColor, @Nullable Integer fourthBackgroundColor, @Nullable Integer intensity, @Nullable Integer rotation) {
        this.identifier = identifier;
        this.flags = flags;
        this.blur = blur;
        this.motion = motion;
        this.backgroundColor = backgroundColor;
        this.secondBackgroundColor = secondBackgroundColor;
        this.thirdBackgroundColor = thirdBackgroundColor;
        this.fourthBackgroundColor = fourthBackgroundColor;
        this.intensity = intensity;
        this.rotation = rotation;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WallPaperSettings.super.identifier();
    }

    private int flagsInitialize() {
        return WallPaperSettings.super.flags();
    }

    private boolean blurInitialize() {
        return WallPaperSettings.super.blur();
    }

    private boolean motionInitialize() {
        return WallPaperSettings.super.motion();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean blur() {
        InitShim shim = this.initShim;
        return shim != null ? shim.blur() : this.blur;
    }

    @Override
    public boolean motion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.motion() : this.motion;
    }

    @Override
    @Nullable
    public Integer backgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @Nullable
    public Integer secondBackgroundColor() {
        return this.secondBackgroundColor;
    }

    @Override
    @Nullable
    public Integer thirdBackgroundColor() {
        return this.thirdBackgroundColor;
    }

    @Override
    @Nullable
    public Integer fourthBackgroundColor() {
        return this.fourthBackgroundColor;
    }

    @Override
    @Nullable
    public Integer intensity() {
        return this.intensity;
    }

    @Override
    @Nullable
    public Integer rotation() {
        return this.rotation;
    }

    public final ImmutableWallPaperSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(value, this.flags, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, value, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withBlur(boolean value) {
        if (this.blur == value) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, value, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withMotion(boolean value) {
        if (this.motion == value) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, value, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withBackgroundColor(@Nullable Integer value) {
        if (Objects.equals(this.backgroundColor, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, value, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withSecondBackgroundColor(@Nullable Integer value) {
        if (Objects.equals(this.secondBackgroundColor, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, this.backgroundColor, value, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withThirdBackgroundColor(@Nullable Integer value) {
        if (Objects.equals(this.thirdBackgroundColor, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, value, this.fourthBackgroundColor, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withFourthBackgroundColor(@Nullable Integer value) {
        if (Objects.equals(this.fourthBackgroundColor, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, value, this.intensity, this.rotation));
    }

    public final ImmutableWallPaperSettings withIntensity(@Nullable Integer value) {
        if (Objects.equals(this.intensity, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, value, this.rotation));
    }

    public final ImmutableWallPaperSettings withRotation(@Nullable Integer value) {
        if (Objects.equals(this.rotation, value)) {
            return this;
        }
        return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this.identifier, this.flags, this.blur, this.motion, this.backgroundColor, this.secondBackgroundColor, this.thirdBackgroundColor, this.fourthBackgroundColor, this.intensity, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWallPaperSettings && this.equalTo(0, (ImmutableWallPaperSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableWallPaperSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.blur == another.blur && this.motion == another.motion && Objects.equals(this.backgroundColor, another.backgroundColor) && Objects.equals(this.secondBackgroundColor, another.secondBackgroundColor) && Objects.equals(this.thirdBackgroundColor, another.thirdBackgroundColor) && Objects.equals(this.fourthBackgroundColor, another.fourthBackgroundColor) && Objects.equals(this.intensity, another.intensity) && Objects.equals(this.rotation, another.rotation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.blur);
        h += (h << 5) + Boolean.hashCode(this.motion);
        h += (h << 5) + Objects.hashCode(this.backgroundColor);
        h += (h << 5) + Objects.hashCode(this.secondBackgroundColor);
        h += (h << 5) + Objects.hashCode(this.thirdBackgroundColor);
        h += (h << 5) + Objects.hashCode(this.fourthBackgroundColor);
        h += (h << 5) + Objects.hashCode(this.intensity);
        h += (h << 5) + Objects.hashCode(this.rotation);
        return h;
    }

    public String toString() {
        return "WallPaperSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", blur=" + this.blur + ", motion=" + this.motion + ", backgroundColor=" + this.backgroundColor + ", secondBackgroundColor=" + this.secondBackgroundColor + ", thirdBackgroundColor=" + this.thirdBackgroundColor + ", fourthBackgroundColor=" + this.fourthBackgroundColor + ", intensity=" + this.intensity + ", rotation=" + this.rotation + "}";
    }

    public static ImmutableWallPaperSettings of() {
        return INSTANCE;
    }

    private static ImmutableWallPaperSettings validate(ImmutableWallPaperSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableWallPaperSettings copyOf(WallPaperSettings instance) {
        if (instance instanceof ImmutableWallPaperSettings) {
            return (ImmutableWallPaperSettings)instance;
        }
        return ImmutableWallPaperSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BLUR = 4L;
        private static final long OPT_BIT_MOTION = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean blur;
        private boolean motion;
        private Integer backgroundColor;
        private Integer secondBackgroundColor;
        private Integer thirdBackgroundColor;
        private Integer fourthBackgroundColor;
        private Integer intensity;
        private Integer rotation;

        private Builder() {
        }

        public final Builder from(WallPaperSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WallPaperSettings instance;
            long bits = 0L;
            if (object instanceof WallPaperSettings) {
                Integer rotationValue;
                Integer fourthBackgroundColorValue;
                Integer thirdBackgroundColorValue;
                Integer backgroundColorValue;
                instance = (WallPaperSettings)object;
                Integer intensityValue = instance.intensity();
                if (intensityValue != null) {
                    this.intensity(intensityValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((backgroundColorValue = instance.backgroundColor()) != null) {
                    this.backgroundColor(backgroundColorValue);
                }
                if ((thirdBackgroundColorValue = instance.thirdBackgroundColor()) != null) {
                    this.thirdBackgroundColor(thirdBackgroundColorValue);
                }
                if ((fourthBackgroundColorValue = instance.fourthBackgroundColor()) != null) {
                    this.fourthBackgroundColor(fourthBackgroundColorValue);
                }
                this.motion(instance.motion());
                Integer secondBackgroundColorValue = instance.secondBackgroundColor();
                if (secondBackgroundColorValue != null) {
                    this.secondBackgroundColor(secondBackgroundColorValue);
                }
                if ((rotationValue = instance.rotation()) != null) {
                    this.rotation(rotationValue);
                }
                this.flags(instance.flags());
                this.blur(instance.blur());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder blur(boolean blur) {
            this.blur = blur;
            this.optBits |= 4L;
            return this;
        }

        public final Builder motion(boolean motion) {
            this.motion = motion;
            this.optBits |= 8L;
            return this;
        }

        public final Builder backgroundColor(@Nullable Integer backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Builder secondBackgroundColor(@Nullable Integer secondBackgroundColor) {
            this.secondBackgroundColor = secondBackgroundColor;
            return this;
        }

        public final Builder thirdBackgroundColor(@Nullable Integer thirdBackgroundColor) {
            this.thirdBackgroundColor = thirdBackgroundColor;
            return this;
        }

        public final Builder fourthBackgroundColor(@Nullable Integer fourthBackgroundColor) {
            this.fourthBackgroundColor = fourthBackgroundColor;
            return this;
        }

        public final Builder intensity(@Nullable Integer intensity) {
            this.intensity = intensity;
            return this;
        }

        public final Builder rotation(@Nullable Integer rotation) {
            this.rotation = rotation;
            return this;
        }

        public ImmutableWallPaperSettings build() {
            return ImmutableWallPaperSettings.validate(new ImmutableWallPaperSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean blurIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean motionIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte blurBuildStage = 0;
        private boolean blur;
        private byte motionBuildStage = 0;
        private boolean motion;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWallPaperSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableWallPaperSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean blur() {
            if (this.blurBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.blurBuildStage == 0) {
                this.blurBuildStage = (byte)-1;
                this.blur = ImmutableWallPaperSettings.this.blurInitialize();
                this.blurBuildStage = 1;
            }
            return this.blur;
        }

        void blur(boolean blur) {
            this.blur = blur;
            this.blurBuildStage = 1;
        }

        boolean motion() {
            if (this.motionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.motionBuildStage == 0) {
                this.motionBuildStage = (byte)-1;
                this.motion = ImmutableWallPaperSettings.this.motionInitialize();
                this.motionBuildStage = 1;
            }
            return this.motion;
        }

        void motion(boolean motion) {
            this.motion = motion;
            this.motionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.blurBuildStage == -1) {
                attributes.add("blur");
            }
            if (this.motionBuildStage == -1) {
                attributes.add("motion");
            }
            return "Cannot build WallPaperSettings, attribute initializers form cycle " + attributes;
        }
    }
}

