/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.WebAuthorization;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebAuthorization
implements WebAuthorization {
    private final int identifier;
    private final long hash;
    private final long botId;
    private final String domain;
    private final String browser;
    private final String platform;
    private final int dateCreated;
    private final int dateActive;
    private final String ip;
    private final String region;

    private ImmutableWebAuthorization(long hash, long botId, String domain, String browser, String platform, int dateCreated, int dateActive, String ip, String region) {
        this.hash = hash;
        this.botId = botId;
        this.domain = Objects.requireNonNull(domain, "domain");
        this.browser = Objects.requireNonNull(browser, "browser");
        this.platform = Objects.requireNonNull(platform, "platform");
        this.dateCreated = dateCreated;
        this.dateActive = dateActive;
        this.ip = Objects.requireNonNull(ip, "ip");
        this.region = Objects.requireNonNull(region, "region");
        this.identifier = WebAuthorization.super.identifier();
    }

    private ImmutableWebAuthorization(Builder builder) {
        this.hash = builder.hash;
        this.botId = builder.botId;
        this.domain = builder.domain;
        this.browser = builder.browser;
        this.platform = builder.platform;
        this.dateCreated = builder.dateCreated;
        this.dateActive = builder.dateActive;
        this.ip = builder.ip;
        this.region = builder.region;
        this.identifier = builder.identifierIsSet() ? builder.identifier : WebAuthorization.super.identifier();
    }

    private ImmutableWebAuthorization(int identifier, long hash, long botId, String domain, String browser, String platform, int dateCreated, int dateActive, String ip, String region) {
        this.identifier = identifier;
        this.hash = hash;
        this.botId = botId;
        this.domain = domain;
        this.browser = browser;
        this.platform = platform;
        this.dateCreated = dateCreated;
        this.dateActive = dateActive;
        this.ip = ip;
        this.region = region;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public String browser() {
        return this.browser;
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public int dateCreated() {
        return this.dateCreated;
    }

    @Override
    public int dateActive() {
        return this.dateActive;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public String region() {
        return this.region;
    }

    public final ImmutableWebAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWebAuthorization(value, this.hash, this.botId, this.domain, this.browser, this.platform, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, value, this.botId, this.domain, this.browser, this.platform, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, value, this.domain, this.browser, this.platform, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (this.domain.equals(newValue)) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, newValue, this.browser, this.platform, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withBrowser(String value) {
        String newValue = Objects.requireNonNull(value, "browser");
        if (this.browser.equals(newValue)) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, newValue, this.platform, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withPlatform(String value) {
        String newValue = Objects.requireNonNull(value, "platform");
        if (this.platform.equals(newValue)) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, this.browser, newValue, this.dateCreated, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withDateCreated(int value) {
        if (this.dateCreated == value) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, this.browser, this.platform, value, this.dateActive, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withDateActive(int value) {
        if (this.dateActive == value) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, this.browser, this.platform, this.dateCreated, value, this.ip, this.region);
    }

    public final ImmutableWebAuthorization withIp(String value) {
        String newValue = Objects.requireNonNull(value, "ip");
        if (this.ip.equals(newValue)) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, this.browser, this.platform, this.dateCreated, this.dateActive, newValue, this.region);
    }

    public final ImmutableWebAuthorization withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableWebAuthorization(this.identifier, this.hash, this.botId, this.domain, this.browser, this.platform, this.dateCreated, this.dateActive, this.ip, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebAuthorization && this.equalTo(0, (ImmutableWebAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebAuthorization another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.botId == another.botId && this.domain.equals(another.domain) && this.browser.equals(another.browser) && this.platform.equals(another.platform) && this.dateCreated == another.dateCreated && this.dateActive == another.dateActive && this.ip.equals(another.ip) && this.region.equals(another.region);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.domain.hashCode();
        h += (h << 5) + this.browser.hashCode();
        h += (h << 5) + this.platform.hashCode();
        h += (h << 5) + this.dateCreated;
        h += (h << 5) + this.dateActive;
        h += (h << 5) + this.ip.hashCode();
        h += (h << 5) + this.region.hashCode();
        return h;
    }

    public String toString() {
        return "WebAuthorization{identifier=" + this.identifier + ", hash=" + this.hash + ", botId=" + this.botId + ", domain=" + this.domain + ", browser=" + this.browser + ", platform=" + this.platform + ", dateCreated=" + this.dateCreated + ", dateActive=" + this.dateActive + ", ip=" + this.ip + ", region=" + this.region + "}";
    }

    public static ImmutableWebAuthorization of(long hash, long botId, String domain, String browser, String platform, int dateCreated, int dateActive, String ip, String region) {
        return new ImmutableWebAuthorization(hash, botId, domain, browser, platform, dateCreated, dateActive, ip, region);
    }

    public static ImmutableWebAuthorization copyOf(WebAuthorization instance) {
        if (instance instanceof ImmutableWebAuthorization) {
            return (ImmutableWebAuthorization)instance;
        }
        return ImmutableWebAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long INIT_BIT_DOMAIN = 4L;
        private static final long INIT_BIT_BROWSER = 8L;
        private static final long INIT_BIT_PLATFORM = 16L;
        private static final long INIT_BIT_DATE_CREATED = 32L;
        private static final long INIT_BIT_DATE_ACTIVE = 64L;
        private static final long INIT_BIT_IP = 128L;
        private static final long INIT_BIT_REGION = 256L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 511L;
        private long optBits;
        private int identifier;
        private long hash;
        private long botId;
        private String domain;
        private String browser;
        private String platform;
        private int dateCreated;
        private int dateActive;
        private String ip;
        private String region;

        private Builder() {
        }

        public final Builder from(WebAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WebAuthorization instance;
            long bits = 0L;
            if (object instanceof WebAuthorization) {
                instance = (WebAuthorization)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.dateCreated(instance.dateCreated());
                this.dateActive(instance.dateActive());
                this.domain(instance.domain());
                this.browser(instance.browser());
                this.ip(instance.ip());
                this.botId(instance.botId());
                this.region(instance.region());
                this.hash(instance.hash());
                this.platform(instance.platform());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder browser(String browser) {
            this.browser = Objects.requireNonNull(browser, "browser");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder platform(String platform) {
            this.platform = Objects.requireNonNull(platform, "platform");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder dateCreated(int dateCreated) {
            this.dateCreated = dateCreated;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder dateActive(int dateActive) {
            this.dateActive = dateActive;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder ip(String ip) {
            this.ip = Objects.requireNonNull(ip, "ip");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableWebAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("domain");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("browser");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("platform");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("dateCreated");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("dateActive");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("ip");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("region");
            }
            return "Cannot build WebAuthorization, some of required attributes are not set " + attributes;
        }
    }
}

