/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.ThemeSettings;
import telegram4j.tl.WebPageAttribute;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebPageAttribute
implements WebPageAttribute {
    private final int identifier;
    private final int flags;
    @Nullable
    private final List<Document> documents;
    @Nullable
    private final ThemeSettings settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableWebPageAttribute INSTANCE = ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute());

    private ImmutableWebPageAttribute() {
        this.documents = null;
        this.settings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebPageAttribute(Builder builder) {
        this.documents = builder.documents == null ? null : ImmutableWebPageAttribute.createUnmodifiableList(true, builder.documents);
        this.settings = builder.settings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebPageAttribute(int identifier, int flags, @Nullable List<Document> documents, @Nullable ThemeSettings settings) {
        this.identifier = identifier;
        this.flags = flags;
        this.documents = documents;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WebPageAttribute.super.identifier();
    }

    private int flagsInitialize() {
        return WebPageAttribute.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public List<Document> documents() {
        return this.documents;
    }

    @Override
    @Nullable
    public ThemeSettings settings() {
        return this.settings;
    }

    public final ImmutableWebPageAttribute withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(value, this.flags, this.documents, this.settings));
    }

    public final ImmutableWebPageAttribute withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this.identifier, value, this.documents, this.settings));
    }

    public final ImmutableWebPageAttribute withDocuments(Document ... elements) {
        if (elements == null) {
            return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this.identifier, this.flags, null, this.settings));
        }
        List<Document> newValue = Arrays.asList(elements) == null ? null : ImmutableWebPageAttribute.createUnmodifiableList(false, ImmutableWebPageAttribute.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this.identifier, this.flags, newValue, this.settings));
    }

    public final ImmutableWebPageAttribute withDocuments(@Nullable Iterable<? extends Document> elements) {
        if (this.documents == elements) {
            return this;
        }
        List<Document> newValue = elements == null ? null : ImmutableWebPageAttribute.createUnmodifiableList(false, ImmutableWebPageAttribute.createSafeList(elements, true, false));
        return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this.identifier, this.flags, newValue, this.settings));
    }

    public final ImmutableWebPageAttribute withSettings(@Nullable ThemeSettings value) {
        if (this.settings == value) {
            return this;
        }
        return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this.identifier, this.flags, this.documents, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebPageAttribute && this.equalTo(0, (ImmutableWebPageAttribute)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebPageAttribute another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.documents, another.documents) && Objects.equals(this.settings, another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.documents);
        h += (h << 5) + Objects.hashCode(this.settings);
        return h;
    }

    public String toString() {
        return "WebPageAttribute{identifier=" + this.identifier + ", flags=" + this.flags + ", documents=" + this.documents + ", settings=" + this.settings + "}";
    }

    public static ImmutableWebPageAttribute of() {
        return INSTANCE;
    }

    private static ImmutableWebPageAttribute validate(ImmutableWebPageAttribute instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableWebPageAttribute copyOf(WebPageAttribute instance) {
        if (instance instanceof ImmutableWebPageAttribute) {
            return (ImmutableWebPageAttribute)instance;
        }
        return ImmutableWebPageAttribute.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private List<Document> documents = null;
        private ThemeSettings settings;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebPageAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WebPageAttribute) {
                List<Document> documentsValue;
                ThemeSettings settingsValue;
                instance = (WebPageAttribute)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((settingsValue = instance.settings()) != null) {
                    this.settings(settingsValue);
                }
                if ((documentsValue = instance.documents()) != null) {
                    this.addAllDocuments(documentsValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder addDocument(Document element) {
            if (this.documents == null) {
                this.documents = new ArrayList<Document>();
            }
            this.documents.add(Objects.requireNonNull(element, "documents element"));
            return this;
        }

        public final Builder addDocuments(Document ... elements) {
            if (this.documents == null) {
                this.documents = new ArrayList<Document>();
            }
            for (Document element : elements) {
                this.documents.add(Objects.requireNonNull(element, "documents element"));
            }
            return this;
        }

        public final Builder documents(@Nullable Iterable<? extends Document> elements) {
            if (elements == null) {
                this.documents = null;
                return this;
            }
            this.documents = new ArrayList<Document>();
            return this.addAllDocuments(elements);
        }

        public final Builder addAllDocuments(Iterable<? extends Document> elements) {
            Objects.requireNonNull(elements, "documents element");
            if (this.documents == null) {
                this.documents = new ArrayList<Document>();
            }
            for (Document document : elements) {
                this.documents.add(Objects.requireNonNull(document, "documents element"));
            }
            return this;
        }

        public final Builder settings(@Nullable ThemeSettings settings) {
            this.settings = settings;
            return this;
        }

        public ImmutableWebPageAttribute build() {
            return ImmutableWebPageAttribute.validate(new ImmutableWebPageAttribute(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWebPageAttribute.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableWebPageAttribute.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build WebPageAttribute, attribute initializers form cycle " + attributes;
        }
    }
}

