/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.WebPage;
import telegram4j.tl.WebPageNotModified;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebPageNotModified
implements WebPageNotModified {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer cachedPageViews;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableWebPageNotModified INSTANCE = ImmutableWebPageNotModified.validate(new ImmutableWebPageNotModified());

    private ImmutableWebPageNotModified() {
        this.cachedPageViews = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebPageNotModified(Builder builder) {
        this.cachedPageViews = builder.cachedPageViews;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebPageNotModified(int identifier, int flags, @Nullable Integer cachedPageViews) {
        this.identifier = identifier;
        this.flags = flags;
        this.cachedPageViews = cachedPageViews;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WebPageNotModified.super.identifier();
    }

    private int flagsInitialize() {
        return WebPageNotModified.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer cachedPageViews() {
        return this.cachedPageViews;
    }

    public final ImmutableWebPageNotModified withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableWebPageNotModified.validate(new ImmutableWebPageNotModified(value, this.flags, this.cachedPageViews));
    }

    public final ImmutableWebPageNotModified withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableWebPageNotModified.validate(new ImmutableWebPageNotModified(this.identifier, value, this.cachedPageViews));
    }

    public final ImmutableWebPageNotModified withCachedPageViews(@Nullable Integer value) {
        if (Objects.equals(this.cachedPageViews, value)) {
            return this;
        }
        return ImmutableWebPageNotModified.validate(new ImmutableWebPageNotModified(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebPageNotModified && this.equalTo(0, (ImmutableWebPageNotModified)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebPageNotModified another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.cachedPageViews, another.cachedPageViews);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.cachedPageViews);
        return h;
    }

    public String toString() {
        return "WebPageNotModified{identifier=" + this.identifier + ", flags=" + this.flags + ", cachedPageViews=" + this.cachedPageViews + "}";
    }

    public static ImmutableWebPageNotModified of() {
        return INSTANCE;
    }

    private static ImmutableWebPageNotModified validate(ImmutableWebPageNotModified instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableWebPageNotModified copyOf(WebPageNotModified instance) {
        if (instance instanceof ImmutableWebPageNotModified) {
            return (ImmutableWebPageNotModified)instance;
        }
        return ImmutableWebPageNotModified.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Integer cachedPageViews;

        private Builder() {
        }

        public final Builder from(WebPageNotModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WebPage instance;
            long bits = 0L;
            if (object instanceof WebPageNotModified) {
                Integer cachedPageViewsValue;
                instance = (WebPageNotModified)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((cachedPageViewsValue = instance.cachedPageViews()) != null) {
                    this.cachedPageViews(cachedPageViewsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WebPage) {
                instance = (WebPage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder cachedPageViews(@Nullable Integer cachedPageViews) {
            this.cachedPageViews = cachedPageViews;
            return this;
        }

        public ImmutableWebPageNotModified build() {
            return ImmutableWebPageNotModified.validate(new ImmutableWebPageNotModified(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWebPageNotModified.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableWebPageNotModified.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build WebPageNotModified, attribute initializers form cycle " + attributes;
        }
    }
}

