/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.WebPage;
import telegram4j.tl.WebPagePending;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebPagePending
implements WebPagePending {
    private final int identifier;
    private final long id;
    private final int date;

    private ImmutableWebPagePending(long id, int date) {
        this.id = id;
        this.date = date;
        this.identifier = WebPagePending.super.identifier();
    }

    private ImmutableWebPagePending(Builder builder) {
        this.id = builder.id;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : WebPagePending.super.identifier();
    }

    private ImmutableWebPagePending(int identifier, long id, int date) {
        this.identifier = identifier;
        this.id = id;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableWebPagePending withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWebPagePending(value, this.id, this.date);
    }

    public final ImmutableWebPagePending withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableWebPagePending(this.identifier, value, this.date);
    }

    public final ImmutableWebPagePending withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableWebPagePending(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebPagePending && this.equalTo(0, (ImmutableWebPagePending)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebPagePending another) {
        return this.identifier == another.identifier && this.id == another.id && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "WebPagePending{identifier=" + this.identifier + ", id=" + this.id + ", date=" + this.date + "}";
    }

    public static ImmutableWebPagePending of(long id, int date) {
        return new ImmutableWebPagePending(id, date);
    }

    public static ImmutableWebPagePending copyOf(WebPagePending instance) {
        if (instance instanceof ImmutableWebPagePending) {
            return (ImmutableWebPagePending)instance;
        }
        return ImmutableWebPagePending.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private int date;

        private Builder() {
        }

        public final Builder from(WebPagePending instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WebPage instance;
            long bits = 0L;
            if (object instanceof WebPagePending) {
                instance = (WebPagePending)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WebPage) {
                instance = (WebPage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWebPagePending build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebPagePending(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build WebPagePending, some of required attributes are not set " + attributes;
        }
    }
}

