/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.WebViewMessageSent;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebViewMessageSent
implements WebViewMessageSent {
    private final int identifier;
    private final int flags;
    @Nullable
    private final InputBotInlineMessageID msgId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableWebViewMessageSent INSTANCE = ImmutableWebViewMessageSent.validate(new ImmutableWebViewMessageSent());

    private ImmutableWebViewMessageSent() {
        this.msgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebViewMessageSent(Builder builder) {
        this.msgId = builder.msgId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableWebViewMessageSent(int identifier, int flags, @Nullable InputBotInlineMessageID msgId) {
        this.identifier = identifier;
        this.flags = flags;
        this.msgId = msgId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return WebViewMessageSent.super.identifier();
    }

    private int flagsInitialize() {
        return WebViewMessageSent.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public InputBotInlineMessageID msgId() {
        return this.msgId;
    }

    public final ImmutableWebViewMessageSent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableWebViewMessageSent.validate(new ImmutableWebViewMessageSent(value, this.flags, this.msgId));
    }

    public final ImmutableWebViewMessageSent withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableWebViewMessageSent.validate(new ImmutableWebViewMessageSent(this.identifier, value, this.msgId));
    }

    public final ImmutableWebViewMessageSent withMsgId(@Nullable InputBotInlineMessageID value) {
        if (this.msgId == value) {
            return this;
        }
        return ImmutableWebViewMessageSent.validate(new ImmutableWebViewMessageSent(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebViewMessageSent && this.equalTo(0, (ImmutableWebViewMessageSent)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebViewMessageSent another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.msgId, another.msgId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.msgId);
        return h;
    }

    public String toString() {
        return "WebViewMessageSent{identifier=" + this.identifier + ", flags=" + this.flags + ", msgId=" + this.msgId + "}";
    }

    public static ImmutableWebViewMessageSent of() {
        return INSTANCE;
    }

    private static ImmutableWebViewMessageSent validate(ImmutableWebViewMessageSent instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableWebViewMessageSent copyOf(WebViewMessageSent instance) {
        if (instance instanceof ImmutableWebViewMessageSent) {
            return (ImmutableWebViewMessageSent)instance;
        }
        return ImmutableWebViewMessageSent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputBotInlineMessageID msgId;

        private Builder() {
        }

        public final Builder from(WebViewMessageSent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WebViewMessageSent instance;
            long bits = 0L;
            if (object instanceof WebViewMessageSent) {
                InputBotInlineMessageID msgIdValue;
                instance = (WebViewMessageSent)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((msgIdValue = instance.msgId()) != null) {
                    this.msgId(msgIdValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder msgId(@Nullable InputBotInlineMessageID msgId) {
            this.msgId = msgId;
            return this;
        }

        public ImmutableWebViewMessageSent build() {
            return ImmutableWebViewMessageSent.validate(new ImmutableWebViewMessageSent(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableWebViewMessageSent.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableWebViewMessageSent.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build WebViewMessageSent, attribute initializers form cycle " + attributes;
        }
    }
}

