/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.WebViewResult;
import telegram4j.tl.api.TlObject;

public final class ImmutableWebViewResult
implements WebViewResult {
    private final int identifier;
    private final long queryId;
    private final String url;

    private ImmutableWebViewResult(long queryId, String url) {
        this.queryId = queryId;
        this.url = Objects.requireNonNull(url, "url");
        this.identifier = WebViewResult.super.identifier();
    }

    private ImmutableWebViewResult(Builder builder) {
        this.queryId = builder.queryId;
        this.url = builder.url;
        this.identifier = builder.identifierIsSet() ? builder.identifier : WebViewResult.super.identifier();
    }

    private ImmutableWebViewResult(int identifier, long queryId, String url) {
        this.identifier = identifier;
        this.queryId = queryId;
        this.url = url;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableWebViewResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableWebViewResult(value, this.queryId, this.url);
    }

    public final ImmutableWebViewResult withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableWebViewResult(this.identifier, value, this.url);
    }

    public final ImmutableWebViewResult withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableWebViewResult(this.identifier, this.queryId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebViewResult && this.equalTo(0, (ImmutableWebViewResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebViewResult another) {
        return this.identifier == another.identifier && this.queryId == another.queryId && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "WebViewResult{identifier=" + this.identifier + ", queryId=" + this.queryId + ", url=" + this.url + "}";
    }

    public static ImmutableWebViewResult of(long queryId, String url) {
        return new ImmutableWebViewResult(queryId, url);
    }

    public static ImmutableWebViewResult copyOf(WebViewResult instance) {
        if (instance instanceof ImmutableWebViewResult) {
            return (ImmutableWebViewResult)instance;
        }
        return ImmutableWebViewResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long queryId;
        private String url;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebViewResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WebViewResult) {
                instance = (WebViewResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
                this.queryId(instance.queryId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWebViewResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebViewResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build WebViewResult, some of required attributes are not set " + attributes;
        }
    }
}

