/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.StreamSupport;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import reactor.core.Exceptions;
import reactor.util.annotation.Nullable;
import telegram4j.tl.TlDeserializer;
import telegram4j.tl.TlSerializer;
import telegram4j.tl.api.TlObject;

public final class TlSerialUtil {
    private TlSerialUtil() {
    }

    public static ByteBuf compressGzip(ByteBufAllocator allocator, int level, ByteBuf buf) {
        ByteBuf byteBuf;
        ByteBufOutputStream bufOut = new ByteBufOutputStream(allocator.buffer(buf.readableBytes()));
        CompressibleGZIPOutputStream out = new CompressibleGZIPOutputStream((OutputStream)bufOut, level);
        try {
            out.write(ByteBufUtil.getBytes((ByteBuf)buf));
            ((DeflaterOutputStream)out).finish();
            buf.release();
            byteBuf = bufOut.buffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        out.close();
        return byteBuf;
    }

    public static ByteBuf compressGzip(ByteBufAllocator allocator, int level, TlObject object) {
        return TlSerialUtil.compressGzip(allocator, level, TlSerializer.serialize(allocator, object));
    }

    public static <T> T decompressGzip(ByteBuf packed) {
        ByteBuf result = packed.alloc().buffer(packed.readableBytes());
        try {
            Object t;
            GZIPInputStream in = new GZIPInputStream((InputStream)new ByteBufInputStream(packed));
            try {
                int n;
                int remaining = Integer.MAX_VALUE;
                do {
                    byte[] buf = new byte[Math.min(remaining, 8192)];
                    int nread = 0;
                    while ((n = in.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                        nread += n;
                        remaining -= n;
                    }
                    if (nread <= 0) continue;
                    result.writeBytes(buf, 0, nread);
                } while (n >= 0 && remaining > 0);
                t = TlDeserializer.deserialize(result);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            in.close();
            return t;
        }
        finally {
            result.release();
        }
    }

    public static int sumSizeExact(int base, ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            base = Math.addExact(base, buf.readableBytes());
        }
        return base;
    }

    static ByteBuf readInt128(ByteBuf buf) {
        return buf.readSlice(16);
    }

    static ByteBuf readInt256(ByteBuf buf) {
        return buf.readSlice(32);
    }

    static int sizeOf0(String str) {
        int n = ByteBufUtil.utf8Bytes((CharSequence)str);
        int h = n >= 254 ? 4 : 1;
        int offset = (h + n) % 4;
        return h + n + 4 - offset;
    }

    static int sizeOf0(ByteBuf buf) {
        int n = buf.readableBytes();
        int h = n >= 254 ? 4 : 1;
        int offset = (h + n) % 4;
        return h + n + 4 - offset;
    }

    static int sizeOfIntVector(List<Integer> list) {
        return 8 + list.size() * 4;
    }

    static int sizeOfLongVector(List<Long> list) {
        return 8 + list.size() * 8;
    }

    static int sizeOfStringVector(List<String> list) {
        return TlSerialUtil.sizeOfVector0(list, TlSerialUtil::sizeOf0);
    }

    static int sizeOfBytesVector(List<ByteBuf> list) {
        return TlSerialUtil.sizeOfVector0(list, TlSerialUtil::sizeOf0);
    }

    static int sizeOfVector(List<? extends TlObject> list) {
        return TlSerialUtil.sizeOfVector0(list, TlSerializer::sizeOf);
    }

    static int sizeOfUnknownVector(List<?> list) {
        return TlSerialUtil.sizeOfVector0(list, TlSerialUtil::sizeOfUnknown);
    }

    static <T> int sizeOfVector0(int count, Iterator<T> it, ToIntFunction<T> func) {
        return StreamSupport.stream(Spliterators.spliterator(it, (long)count, 0), false).mapToInt(func).reduce(0, Integer::sum);
    }

    static <T> int sizeOfVector0(List<T> list, ToIntFunction<T> func) {
        return 8 + list.stream().mapToInt(func).reduce(0, Integer::sum);
    }

    static int sizeOfFlags(Optional<?> o) {
        return o.map(TlSerialUtil::sizeOfUnknown).orElse(0);
    }

    static int sizeOfFlags(@Nullable Object o) {
        if (o == null) {
            return 0;
        }
        return TlSerialUtil.sizeOfUnknown(o);
    }

    static int sizeOfUnknown(Object value) {
        if (value instanceof Integer || value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Long || value instanceof Double) {
            return 8;
        }
        if (value instanceof ByteBuf) {
            return TlSerialUtil.sizeOf0((ByteBuf)value);
        }
        if (value instanceof String) {
            return TlSerialUtil.sizeOf0((String)value);
        }
        if (value instanceof List) {
            return TlSerialUtil.sizeOfUnknownVector((List)value);
        }
        if (value instanceof TlObject) {
            return TlSerializer.sizeOf((TlObject)value);
        }
        if (value instanceof JsonNode) {
            return TlSerialUtil.sizeOfJsonNode((JsonNode)value);
        }
        throw new IllegalArgumentException("Incorrect TL serializable type: " + value + " (" + value.getClass() + ")");
    }

    static int sizeOfJsonObjectValue(String name, JsonNode node) {
        return 4 + TlSerialUtil.sizeOf0(name) + TlSerialUtil.sizeOfJsonNode(node);
    }

    static int sizeOfJsonNode(JsonNode node) {
        switch (node.getNodeType()) {
            case NULL: {
                return 4;
            }
            case STRING: {
                return 4 + TlSerialUtil.sizeOf0(node.asText());
            }
            case NUMBER: {
                return 12;
            }
            case BOOLEAN: {
                return 8;
            }
            case ARRAY: {
                return 4 + TlSerialUtil.sizeOfVector0(node.size(), node.elements(), TlSerialUtil::sizeOfJsonNode);
            }
            case OBJECT: {
                return 4 + TlSerialUtil.sizeOfVector0(node.size(), node.fields(), e -> TlSerialUtil.sizeOfJsonObjectValue((String)e.getKey(), (JsonNode)e.getValue()));
            }
        }
        throw new IllegalStateException("Incorrect json node type: " + node.getNodeType());
    }

    public static ByteBuf serializeString(ByteBufAllocator allocator, String value) {
        return TlSerialUtil.serializeBytes(allocator, Unpooled.wrappedBuffer((byte[])value.getBytes(StandardCharsets.UTF_8)));
    }

    public static ByteBuf serializeBytes(ByteBufAllocator allocator, ByteBuf bytes) {
        int n = bytes.readableBytes();
        int h = n >= 254 ? 4 : 1;
        int offset = (h + n) % 4;
        ByteBuf buf = allocator.buffer(h + n + 4 - offset);
        if (n >= 254) {
            buf.writeByte(254);
            buf.writeMediumLE(n);
        } else {
            buf.writeByte(n);
        }
        buf.writeBytes(bytes, bytes.readerIndex(), n);
        if (offset != 0) {
            buf.writeZero(4 - offset);
        }
        return buf;
    }

    public static ByteBuf serializeLongVector(ByteBufAllocator allocator, List<Long> vector) {
        ByteBuf buf = allocator.buffer(8 + 8 * vector.size());
        buf.writeIntLE(481674261);
        buf.writeIntLE(vector.size());
        for (long l : vector) {
            buf.writeLongLE(l);
        }
        return buf;
    }

    public static ByteBuf serializeIntVector(ByteBufAllocator allocator, List<Integer> vector) {
        ByteBuf buf = allocator.buffer(8 + 4 * vector.size());
        buf.writeIntLE(481674261);
        buf.writeIntLE(vector.size());
        for (int i : vector) {
            buf.writeIntLE(i);
        }
        return buf;
    }

    public static ByteBuf serializeStringVector(ByteBufAllocator allocator, List<String> vector) {
        return TlSerialUtil.serializeVector0(allocator, vector, (T e) -> TlSerialUtil.serializeString(allocator, e));
    }

    public static ByteBuf serializeBytesVector(ByteBufAllocator allocator, List<? extends ByteBuf> vector) {
        return TlSerialUtil.serializeVector0(allocator, vector, (T e) -> TlSerialUtil.serializeBytes(allocator, e));
    }

    public static ByteBuf serializeVector(ByteBufAllocator allocator, List<? extends TlObject> vector) {
        return TlSerialUtil.serializeVector0(allocator, vector, (T e) -> TlSerializer.serialize(allocator, e));
    }

    public static ByteBuf serializeFlags(ByteBufAllocator allocator, Optional<?> value) {
        return value.map(o -> TlSerialUtil.serializeUnknown(allocator, o)).orElse(Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf serializeFlags(ByteBufAllocator allocator, @Nullable Object value) {
        if (value == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        return TlSerialUtil.serializeUnknown(allocator, value);
    }

    public static ByteBuf serializeUnknown(ByteBufAllocator allocator, Object value) {
        if (value instanceof Integer) {
            return allocator.buffer(4).writeIntLE(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return allocator.buffer(8).writeLongLE(((Long)value).longValue());
        }
        if (value instanceof Boolean) {
            return allocator.buffer(4).writeIntLE((Boolean)value != false ? -1720552011 : -1132882121);
        }
        if (value instanceof Double) {
            return allocator.buffer(8).writeDoubleLE((double)((Long)value).longValue());
        }
        if (value instanceof ByteBuf) {
            return TlSerialUtil.serializeBytes(allocator, (ByteBuf)value);
        }
        if (value instanceof String) {
            return TlSerialUtil.serializeString(allocator, (String)value);
        }
        if (value instanceof List) {
            return TlSerialUtil.serializeVector0(allocator, (List)value, (T e) -> TlSerialUtil.serializeUnknown(allocator, e));
        }
        if (value instanceof TlObject) {
            return TlSerializer.serialize(allocator, (TlObject)value);
        }
        if (value instanceof JsonNode) {
            return TlSerialUtil.serializeJsonNode(allocator, (JsonNode)value);
        }
        throw new IllegalArgumentException("Incorrect TL serializable type: " + value + " (" + value.getClass() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf serializeJsonObjectValue(ByteBufAllocator allocator, String name, JsonNode value) {
        ByteBuf nameb = TlSerialUtil.serializeString(allocator, name);
        ByteBuf valueb = TlSerialUtil.serializeJsonNode(allocator, value);
        try {
            ByteBuf byteBuf = allocator.buffer(TlSerialUtil.sumSizeExact(4, nameb, valueb)).writeIntLE(-1059185703).writeBytes(nameb).writeBytes(valueb);
            return byteBuf;
        }
        finally {
            nameb.release();
            valueb.release();
        }
    }

    public static ByteBuf serializeJsonNode(ByteBufAllocator allocator, JsonNode node) {
        switch (node.getNodeType()) {
            case NULL: {
                return allocator.buffer(4).writeIntLE(1064139624);
            }
            case STRING: {
                ByteBuf str = TlSerialUtil.serializeString(allocator, node.asText());
                ByteBuf buf = allocator.buffer(4 + str.readableBytes());
                buf.writeIntLE(-1222740358);
                buf.writeBytes(str);
                str.release();
                return buf;
            }
            case NUMBER: {
                return allocator.buffer(12).writeIntLE(736157604).writeDoubleLE(node.asDouble());
            }
            case BOOLEAN: {
                return allocator.buffer(8).writeIntLE(-952869270).writeIntLE(node.asBoolean() ? -1720552011 : -1132882121);
            }
            case ARRAY: {
                ByteBuf vector = TlSerialUtil.serializeVector0(allocator, node.size(), node.elements(), (T e) -> TlSerialUtil.serializeJsonNode(allocator, e));
                ByteBuf buf = allocator.buffer(4 + vector.readableBytes());
                buf.writeIntLE(-146520221);
                buf.writeBytes(vector);
                vector.release();
                return buf;
            }
            case OBJECT: {
                ByteBuf vector = TlSerialUtil.serializeVector0(allocator, node.size(), node.fields(), (T e) -> TlSerialUtil.serializeJsonObjectValue(allocator, (String)e.getKey(), (JsonNode)e.getValue()));
                ByteBuf buf = allocator.buffer(4 + vector.readableBytes());
                buf.writeIntLE(-1715350371);
                buf.writeBytes(vector);
                vector.release();
                return buf;
            }
        }
        throw new IllegalStateException("Incorrect json node type: " + node.getNodeType());
    }

    static <T> ByteBuf serializeVector0(ByteBufAllocator allocator, int count, Iterator<T> it, Function<T, ByteBuf> serializer) {
        ByteBuf[] bytes = new ByteBuf[count];
        int size = 8;
        for (int i = 0; i < count; ++i) {
            ByteBuf buf = serializer.apply(it.next());
            size = Math.addExact(size, buf.readableBytes());
            bytes[i] = buf;
        }
        ByteBuf buf = allocator.buffer(size);
        buf.writeIntLE(481674261);
        buf.writeIntLE(count);
        for (ByteBuf b : bytes) {
            buf.writeBytes(b);
            b.release();
        }
        return buf;
    }

    static <T> ByteBuf serializeVector0(ByteBufAllocator allocator, List<T> vector, Function<T, ByteBuf> serializer) {
        ByteBuf[] bytes = new ByteBuf[vector.size()];
        int size = 8;
        for (int i = 0; i < bytes.length; ++i) {
            ByteBuf buf = serializer.apply(vector.get(i));
            size = Math.addExact(size, buf.readableBytes());
            bytes[i] = buf;
        }
        ByteBuf buf = allocator.buffer(size);
        buf.writeIntLE(481674261);
        buf.writeIntLE(vector.size());
        for (ByteBuf b : bytes) {
            buf.writeBytes(b);
            b.release();
        }
        return buf;
    }

    static void serializeJsonObjectValue0(ByteBuf buf, String name, JsonNode value) {
        buf.writeIntLE(-1059185703);
        TlSerialUtil.serializeString0(buf, name);
        TlSerialUtil.serializeJsonNode0(buf, value);
    }

    static void serializeJsonNode0(ByteBuf buf, JsonNode node) {
        switch (node.getNodeType()) {
            case NULL: {
                buf.writeIntLE(1064139624);
                break;
            }
            case STRING: {
                buf.writeIntLE(-1222740358);
                TlSerialUtil.serializeString0(buf, node.asText());
                break;
            }
            case NUMBER: {
                buf.writeIntLE(736157604);
                buf.writeDoubleLE(node.asDouble());
                break;
            }
            case BOOLEAN: {
                buf.writeIntLE(-952869270);
                buf.writeDoubleLE(node.asBoolean() ? -1.720552011E9 : -1.132882121E9);
                break;
            }
            case ARRAY: {
                buf.writeIntLE(-146520221);
                TlSerialUtil.serializeVector0(buf, node.size(), node.elements(), TlSerialUtil::serializeJsonNode0);
                break;
            }
            case OBJECT: {
                buf.writeIntLE(-1715350371);
                TlSerialUtil.serializeVector0(buf, node.size(), node.fields(), (ByteBuf b, T e) -> TlSerialUtil.serializeJsonObjectValue0(b, (String)e.getKey(), (JsonNode)e.getValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect json node type: " + node.getNodeType());
            }
        }
    }

    static void serializeUnknown0(ByteBuf buf, Object value) {
        if (value instanceof Integer) {
            buf.writeIntLE(((Integer)value).intValue());
        } else if (value instanceof Long) {
            buf.writeLongLE(((Long)value).longValue());
        } else if (value instanceof Boolean) {
            buf.writeIntLE((Boolean)value != false ? -1720552011 : -1132882121);
        } else if (value instanceof Double) {
            buf.writeDoubleLE((double)((Long)value).longValue());
        } else if (value instanceof ByteBuf) {
            TlSerialUtil.serializeBytes0(buf, (ByteBuf)value);
        } else if (value instanceof String) {
            TlSerialUtil.serializeString0(buf, (String)value);
        } else if (value instanceof List) {
            TlSerialUtil.serializeVector0(buf, (List)value, TlSerialUtil::serializeUnknown0);
        } else if (value instanceof TlObject) {
            TlSerializer.serialize0(buf, (TlObject)value);
        } else if (value instanceof JsonNode) {
            TlSerialUtil.serializeJsonNode0(buf, (JsonNode)value);
        } else {
            throw new IllegalArgumentException("Incorrect TL serializable type: " + value + " (" + value.getClass() + ")");
        }
    }

    static void serializeFlags0(ByteBuf buf, Optional<?> value) {
        value.ifPresent(e -> TlSerialUtil.serializeUnknown0(buf, e));
    }

    static void serializeFlags0(ByteBuf buf, @Nullable Object value) {
        if (value != null) {
            TlSerialUtil.serializeUnknown0(buf, value);
        }
    }

    static void serializeStringVector0(ByteBuf buf, List<String> list) {
        TlSerialUtil.serializeVector0(buf, list, TlSerialUtil::serializeString0);
    }

    static void serializeBytesVector0(ByteBuf buf, List<ByteBuf> list) {
        TlSerialUtil.serializeVector0(buf, list, TlSerialUtil::serializeBytes0);
    }

    static void serializeLongVector0(ByteBuf buf, List<Long> list) {
        TlSerialUtil.serializeVector0(buf, list, ByteBuf::writeLongLE);
    }

    static void serializeIntVector0(ByteBuf buf, List<Integer> list) {
        TlSerialUtil.serializeVector0(buf, list, ByteBuf::writeIntLE);
    }

    static void serializeVector0(ByteBuf buf, List<? extends TlObject> list) {
        TlSerialUtil.serializeVector0(buf, list, TlSerializer::serialize0);
    }

    static <T> void serializeVector0(ByteBuf buf, int count, Iterator<T> it, BiConsumer<ByteBuf, T> func) {
        buf.writeIntLE(481674261);
        buf.writeIntLE(count);
        while (it.hasNext()) {
            func.accept(buf, (ByteBuf)it.next());
        }
    }

    static <T> void serializeVector0(ByteBuf buf, List<T> list, BiConsumer<ByteBuf, T> func) {
        TlSerialUtil.serializeVector0(buf, list.size(), list.iterator(), func);
    }

    static void serializeString0(ByteBuf buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        int n = bytes.length;
        int h = n >= 254 ? 4 : 1;
        int offset = (h + n) % 4;
        if (n >= 254) {
            buf.writeByte(254);
            buf.writeMediumLE(n);
        } else {
            buf.writeByte(n);
        }
        buf.writeBytes(bytes);
        if (offset != 0) {
            buf.writeZero(4 - offset);
        }
    }

    static void serializeBytes0(ByteBuf buf, ByteBuf bytes) {
        int n = bytes.readableBytes();
        int h = n >= 254 ? 4 : 1;
        int offset = (h + n) % 4;
        if (n >= 254) {
            buf.writeByte(254);
            buf.writeMediumLE(n);
        } else {
            buf.writeByte(n);
        }
        buf.writeBytes(bytes);
        if (offset != 0) {
            buf.writeZero(4 - offset);
        }
    }

    public static ByteBuf deserializeBytes(ByteBuf buf) {
        int n = buf.readUnsignedByte();
        int h = 1;
        if (n >= 254) {
            n = buf.readUnsignedMediumLE();
            h = 4;
        }
        ByteBuf data = buf.readSlice(n);
        int offset = (n + h) % 4;
        if (offset != 0) {
            buf.skipBytes(4 - offset);
        }
        return data;
    }

    public static String deserializeString(ByteBuf buf) {
        int n = buf.readUnsignedByte();
        int h = 1;
        if (n >= 254) {
            n = buf.readUnsignedMediumLE();
            h = 4;
        }
        ByteBuf data = buf.readSlice(n);
        int offset = (n + h) % 4;
        if (offset != 0) {
            buf.skipBytes(4 - offset);
        }
        return data.toString(StandardCharsets.UTF_8);
    }

    public static boolean deserializeBoolean(ByteBuf buf) {
        int id = buf.readIntLE();
        switch (id) {
            case -1720552011: {
                return true;
            }
            case -1132882121: {
                return false;
            }
        }
        throw new IllegalStateException("Incorrect boolean id: 0x" + Integer.toHexString(id));
    }

    public static List<Long> deserializeLongVector(ByteBuf buf) {
        return TlSerialUtil.deserializeVector0(buf, false, ByteBuf::readLongLE);
    }

    public static List<Integer> deserializeIntVector(ByteBuf buf) {
        return TlSerialUtil.deserializeVector0(buf, false, ByteBuf::readIntLE);
    }

    public static List<String> deserializeStringVector(ByteBuf buf) {
        return TlSerialUtil.deserializeVector0(buf, false, TlSerialUtil::deserializeString);
    }

    public static List<ByteBuf> deserializeBytesVector(ByteBuf buf) {
        return TlSerialUtil.deserializeVector0(buf, false, TlSerialUtil::deserializeBytes);
    }

    public static <T> List<T> deserializeVector(ByteBuf buf) {
        return TlSerialUtil.deserializeVector0(buf, false, TlDeserializer::deserialize);
    }

    public static JsonNode deserializeJsonNode(ByteBuf buf) {
        int identifier = buf.readIntLE();
        switch (identifier) {
            case 1064139624: {
                return NullNode.instance;
            }
            case -952869270: {
                return BooleanNode.valueOf((buf.readIntLE() == -1720552011 ? 1 : 0) != 0);
            }
            case -1222740358: {
                return TextNode.valueOf((String)TlSerialUtil.deserializeString(buf));
            }
            case 736157604: {
                return DoubleNode.valueOf((double)buf.readDoubleLE());
            }
            case -146520221: {
                int vectorId = buf.readIntLE();
                if (vectorId != 481674261) {
                    throw new IllegalStateException("Incorrect vector identifier: 0x" + Integer.toHexString(vectorId));
                }
                int size = buf.readIntLE();
                ArrayNode node = JsonNodeFactory.instance.arrayNode(size);
                for (int i = 0; i < size; ++i) {
                    node.add(TlSerialUtil.deserializeJsonNode(buf));
                }
                return node;
            }
            case -1715350371: {
                int vectorId = buf.readIntLE();
                if (vectorId != 481674261) {
                    throw new IllegalStateException("Incorrect vector identifier: 0x" + Integer.toHexString(vectorId));
                }
                int size = buf.readIntLE();
                ObjectNode node0 = JsonNodeFactory.instance.objectNode();
                for (int i = 0; i < size; ++i) {
                    if (buf.readIntLE() != -1059185703) {
                        throw new IllegalStateException("Incorrect json pair identifier: 0x" + Integer.toHexString(vectorId));
                    }
                    String name = TlSerialUtil.deserializeString(buf);
                    node0.set(name, TlSerialUtil.deserializeJsonNode(buf));
                }
                return node0;
            }
        }
        throw new IllegalArgumentException("Incorrect json node identifier: 0x" + Integer.toHexString(identifier));
    }

    static <T> List<T> deserializeVector0(ByteBuf buf, boolean bare, Function<? super ByteBuf, ? extends T> parser) {
        int vectorId;
        if (!bare && (vectorId = buf.readIntLE()) != 481674261) {
            throw new IllegalStateException("Incorrect vector identifier: 0x" + Integer.toHexString(vectorId));
        }
        int size = buf.readIntLE();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(parser.apply((ByteBuf)buf));
        }
        return list;
    }

    static List<Object> deserializeUnknownVector(ByteBuf buf) {
        int size = buf.readIntLE();
        ArrayList<Object> list = new ArrayList<Object>(size);
        boolean longVec = size * 8 == buf.readableBytes();
        boolean intVec = size * 4 == buf.readableBytes();
        for (int i = 0; i < size; ++i) {
            Number val = longVec ? (Number)buf.readLongLE() : (Number)(intVec ? Integer.valueOf(buf.readIntLE()) : TlDeserializer.deserialize(buf));
            list.add(val);
        }
        return list;
    }

    static class CompressibleGZIPOutputStream
    extends GZIPOutputStream {
        public CompressibleGZIPOutputStream(OutputStream out, int level) throws IOException {
            super(out);
            this.def.setLevel(level);
        }
    }
}

