/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.SecureRequiredType;
import telegram4j.tl.SecureValue;
import telegram4j.tl.SecureValueError;
import telegram4j.tl.User;
import telegram4j.tl.account.AuthorizationForm;
import telegram4j.tl.api.TlObject;

public final class ImmutableAuthorizationForm
implements AuthorizationForm {
    private final int identifier;
    private final int flags;
    private final List<SecureRequiredType> requiredTypes;
    private final List<SecureValue> values;
    private final List<SecureValueError> errors;
    private final List<User> users;
    @Nullable
    private final String privacyPolicyUrl;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAuthorizationForm(Builder builder) {
        this.requiredTypes = ImmutableAuthorizationForm.createUnmodifiableList(true, builder.requiredTypes);
        this.values = ImmutableAuthorizationForm.createUnmodifiableList(true, builder.values);
        this.errors = ImmutableAuthorizationForm.createUnmodifiableList(true, builder.errors);
        this.users = ImmutableAuthorizationForm.createUnmodifiableList(true, builder.users);
        this.privacyPolicyUrl = builder.privacyPolicyUrl;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableAuthorizationForm(int identifier, int flags, List<SecureRequiredType> requiredTypes, List<SecureValue> values, List<SecureValueError> errors, List<User> users, @Nullable String privacyPolicyUrl) {
        this.identifier = identifier;
        this.flags = flags;
        this.requiredTypes = requiredTypes;
        this.values = values;
        this.errors = errors;
        this.users = users;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return AuthorizationForm.super.identifier();
    }

    private int flagsInitialize() {
        return AuthorizationForm.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public List<SecureRequiredType> requiredTypes() {
        return this.requiredTypes;
    }

    @Override
    public List<SecureValue> values() {
        return this.values;
    }

    @Override
    public List<SecureValueError> errors() {
        return this.errors;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    @Nullable
    public String privacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    public final ImmutableAuthorizationForm withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAuthorizationForm(value, this.flags, this.requiredTypes, this.values, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableAuthorizationForm(this.identifier, value, this.requiredTypes, this.values, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withRequiredTypes(SecureRequiredType ... elements) {
        List<SecureRequiredType> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, newValue, this.values, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withRequiredTypes(Iterable<? extends SecureRequiredType> elements) {
        if (this.requiredTypes == elements) {
            return this;
        }
        List<SecureRequiredType> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(elements, true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, newValue, this.values, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withValues(SecureValue ... elements) {
        List<SecureValue> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, newValue, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withValues(Iterable<? extends SecureValue> elements) {
        if (this.values == elements) {
            return this;
        }
        List<SecureValue> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(elements, true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, newValue, this.errors, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withErrors(SecureValueError ... elements) {
        List<SecureValueError> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, this.values, newValue, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withErrors(Iterable<? extends SecureValueError> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<SecureValueError> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(elements, true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, this.values, newValue, this.users, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withUsers(User ... elements) {
        List<User> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, this.values, this.errors, newValue, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableAuthorizationForm.createUnmodifiableList(false, ImmutableAuthorizationForm.createSafeList(elements, true, false));
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, this.values, this.errors, newValue, this.privacyPolicyUrl);
    }

    public final ImmutableAuthorizationForm withPrivacyPolicyUrl(@Nullable String value) {
        if (Objects.equals(this.privacyPolicyUrl, value)) {
            return this;
        }
        return new ImmutableAuthorizationForm(this.identifier, this.flags, this.requiredTypes, this.values, this.errors, this.users, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationForm && this.equalTo(0, (ImmutableAuthorizationForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationForm another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.requiredTypes.equals(another.requiredTypes) && this.values.equals(another.values) && this.errors.equals(another.errors) && this.users.equals(another.users) && Objects.equals(this.privacyPolicyUrl, another.privacyPolicyUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.requiredTypes.hashCode();
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + Objects.hashCode(this.privacyPolicyUrl);
        return h;
    }

    public String toString() {
        return "AuthorizationForm{identifier=" + this.identifier + ", flags=" + this.flags + ", requiredTypes=" + this.requiredTypes + ", values=" + this.values + ", errors=" + this.errors + ", users=" + this.users + ", privacyPolicyUrl=" + this.privacyPolicyUrl + "}";
    }

    public static ImmutableAuthorizationForm copyOf(AuthorizationForm instance) {
        if (instance instanceof ImmutableAuthorizationForm) {
            return (ImmutableAuthorizationForm)instance;
        }
        return ImmutableAuthorizationForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private List<SecureRequiredType> requiredTypes = new ArrayList<SecureRequiredType>();
        private List<SecureValue> values = new ArrayList<SecureValue>();
        private List<SecureValueError> errors = new ArrayList<SecureValueError>();
        private List<User> users = new ArrayList<User>();
        private String privacyPolicyUrl;

        private Builder() {
        }

        public final Builder from(AuthorizationForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AuthorizationForm instance;
            long bits = 0L;
            if (object instanceof AuthorizationForm) {
                instance = (AuthorizationForm)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllRequiredTypes(instance.requiredTypes());
                this.addAllValues(instance.values());
                this.flags(instance.flags());
                String privacyPolicyUrlValue = instance.privacyPolicyUrl();
                if (privacyPolicyUrlValue != null) {
                    this.privacyPolicyUrl(privacyPolicyUrlValue);
                }
                this.addAllErrors(instance.errors());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder addRequiredType(SecureRequiredType element) {
            this.requiredTypes.add(Objects.requireNonNull(element, "requiredTypes element"));
            return this;
        }

        public final Builder addRequiredTypes(SecureRequiredType ... elements) {
            for (SecureRequiredType element : elements) {
                this.requiredTypes.add(Objects.requireNonNull(element, "requiredTypes element"));
            }
            return this;
        }

        public final Builder requiredTypes(Iterable<? extends SecureRequiredType> elements) {
            this.requiredTypes.clear();
            return this.addAllRequiredTypes(elements);
        }

        public final Builder addAllRequiredTypes(Iterable<? extends SecureRequiredType> elements) {
            for (SecureRequiredType secureRequiredType : elements) {
                this.requiredTypes.add(Objects.requireNonNull(secureRequiredType, "requiredTypes element"));
            }
            return this;
        }

        public final Builder addValue(SecureValue element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        public final Builder addValues(SecureValue ... elements) {
            for (SecureValue element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder values(Iterable<? extends SecureValue> elements) {
            this.values.clear();
            return this.addAllValues(elements);
        }

        public final Builder addAllValues(Iterable<? extends SecureValue> elements) {
            for (SecureValue secureValue : elements) {
                this.values.add(Objects.requireNonNull(secureValue, "values element"));
            }
            return this;
        }

        public final Builder addError(SecureValueError element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder addErrors(SecureValueError ... elements) {
            for (SecureValueError element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        public final Builder errors(Iterable<? extends SecureValueError> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends SecureValueError> elements) {
            for (SecureValueError secureValueError : elements) {
                this.errors.add(Objects.requireNonNull(secureValueError, "errors element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder privacyPolicyUrl(@Nullable String privacyPolicyUrl) {
            this.privacyPolicyUrl = privacyPolicyUrl;
            return this;
        }

        public ImmutableAuthorizationForm build() {
            return new ImmutableAuthorizationForm(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableAuthorizationForm.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableAuthorizationForm.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build AuthorizationForm, attribute initializers form cycle " + attributes;
        }
    }
}

