/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Authorization;
import telegram4j.tl.account.Authorizations;
import telegram4j.tl.api.TlObject;

public final class ImmutableAuthorizations
implements Authorizations {
    private final int identifier;
    private final int authorizationTtlDays;
    private final List<Authorization> authorizations;

    private ImmutableAuthorizations(int authorizationTtlDays) {
        this.authorizationTtlDays = authorizationTtlDays;
        this.authorizations = Collections.emptyList();
        this.identifier = Authorizations.super.identifier();
    }

    private ImmutableAuthorizations(Builder builder) {
        this.authorizationTtlDays = builder.authorizationTtlDays;
        this.authorizations = ImmutableAuthorizations.createUnmodifiableList(true, builder.authorizations);
        this.identifier = builder.identifierIsSet() ? builder.identifier : Authorizations.super.identifier();
    }

    private ImmutableAuthorizations(int identifier, int authorizationTtlDays, List<Authorization> authorizations) {
        this.identifier = identifier;
        this.authorizationTtlDays = authorizationTtlDays;
        this.authorizations = authorizations;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int authorizationTtlDays() {
        return this.authorizationTtlDays;
    }

    @Override
    public List<Authorization> authorizations() {
        return this.authorizations;
    }

    public final ImmutableAuthorizations withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAuthorizations(value, this.authorizationTtlDays, this.authorizations);
    }

    public final ImmutableAuthorizations withAuthorizationTtlDays(int value) {
        if (this.authorizationTtlDays == value) {
            return this;
        }
        return new ImmutableAuthorizations(this.identifier, value, this.authorizations);
    }

    public final ImmutableAuthorizations withAuthorizations(Authorization ... elements) {
        List<Authorization> newValue = ImmutableAuthorizations.createUnmodifiableList(false, ImmutableAuthorizations.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuthorizations(this.identifier, this.authorizationTtlDays, newValue);
    }

    public final ImmutableAuthorizations withAuthorizations(Iterable<? extends Authorization> elements) {
        if (this.authorizations == elements) {
            return this;
        }
        List<Authorization> newValue = ImmutableAuthorizations.createUnmodifiableList(false, ImmutableAuthorizations.createSafeList(elements, true, false));
        return new ImmutableAuthorizations(this.identifier, this.authorizationTtlDays, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizations && this.equalTo(0, (ImmutableAuthorizations)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizations another) {
        return this.identifier == another.identifier && this.authorizationTtlDays == another.authorizationTtlDays && this.authorizations.equals(another.authorizations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.authorizationTtlDays;
        h += (h << 5) + this.authorizations.hashCode();
        return h;
    }

    public String toString() {
        return "Authorizations{identifier=" + this.identifier + ", authorizationTtlDays=" + this.authorizationTtlDays + ", authorizations=" + this.authorizations + "}";
    }

    public static ImmutableAuthorizations of(int authorizationTtlDays) {
        return new ImmutableAuthorizations(authorizationTtlDays);
    }

    public static ImmutableAuthorizations copyOf(Authorizations instance) {
        if (instance instanceof ImmutableAuthorizations) {
            return (ImmutableAuthorizations)instance;
        }
        return ImmutableAuthorizations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_TTL_DAYS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int authorizationTtlDays;
        private List<Authorization> authorizations = new ArrayList<Authorization>();

        private Builder() {
        }

        public final Builder from(Authorizations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Authorizations instance;
            long bits = 0L;
            if (object instanceof Authorizations) {
                instance = (Authorizations)object;
                this.addAllAuthorizations(instance.authorizations());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.authorizationTtlDays(instance.authorizationTtlDays());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder authorizationTtlDays(int authorizationTtlDays) {
            this.authorizationTtlDays = authorizationTtlDays;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAuthorization(Authorization element) {
            this.authorizations.add(Objects.requireNonNull(element, "authorizations element"));
            return this;
        }

        public final Builder addAuthorizations(Authorization ... elements) {
            for (Authorization element : elements) {
                this.authorizations.add(Objects.requireNonNull(element, "authorizations element"));
            }
            return this;
        }

        public final Builder authorizations(Iterable<? extends Authorization> elements) {
            this.authorizations.clear();
            return this.addAllAuthorizations(elements);
        }

        public final Builder addAllAuthorizations(Iterable<? extends Authorization> elements) {
            for (Authorization authorization : elements) {
                this.authorizations.add(Objects.requireNonNull(authorization, "authorizations element"));
            }
            return this;
        }

        public ImmutableAuthorizations build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizations(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationTtlDays");
            }
            return "Cannot build Authorizations, some of required attributes are not set " + attributes;
        }
    }
}

