/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AutoDownloadSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableAutoDownloadSettings
implements telegram4j.tl.account.AutoDownloadSettings {
    private final int identifier;
    private final AutoDownloadSettings low;
    private final AutoDownloadSettings medium;
    private final AutoDownloadSettings high;

    private ImmutableAutoDownloadSettings(AutoDownloadSettings low, AutoDownloadSettings medium, AutoDownloadSettings high) {
        this.low = Objects.requireNonNull(low, "low");
        this.medium = Objects.requireNonNull(medium, "medium");
        this.high = Objects.requireNonNull(high, "high");
        this.identifier = telegram4j.tl.account.AutoDownloadSettings.super.identifier();
    }

    private ImmutableAutoDownloadSettings(Builder builder) {
        this.low = builder.low;
        this.medium = builder.medium;
        this.high = builder.high;
        this.identifier = builder.identifierIsSet() ? builder.identifier : telegram4j.tl.account.AutoDownloadSettings.super.identifier();
    }

    private ImmutableAutoDownloadSettings(int identifier, AutoDownloadSettings low, AutoDownloadSettings medium, AutoDownloadSettings high) {
        this.identifier = identifier;
        this.low = low;
        this.medium = medium;
        this.high = high;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public AutoDownloadSettings low() {
        return this.low;
    }

    @Override
    public AutoDownloadSettings medium() {
        return this.medium;
    }

    @Override
    public AutoDownloadSettings high() {
        return this.high;
    }

    public final ImmutableAutoDownloadSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAutoDownloadSettings(value, this.low, this.medium, this.high);
    }

    public final ImmutableAutoDownloadSettings withLow(AutoDownloadSettings value) {
        if (this.low == value) {
            return this;
        }
        AutoDownloadSettings newValue = Objects.requireNonNull(value, "low");
        return new ImmutableAutoDownloadSettings(this.identifier, newValue, this.medium, this.high);
    }

    public final ImmutableAutoDownloadSettings withMedium(AutoDownloadSettings value) {
        if (this.medium == value) {
            return this;
        }
        AutoDownloadSettings newValue = Objects.requireNonNull(value, "medium");
        return new ImmutableAutoDownloadSettings(this.identifier, this.low, newValue, this.high);
    }

    public final ImmutableAutoDownloadSettings withHigh(AutoDownloadSettings value) {
        if (this.high == value) {
            return this;
        }
        AutoDownloadSettings newValue = Objects.requireNonNull(value, "high");
        return new ImmutableAutoDownloadSettings(this.identifier, this.low, this.medium, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAutoDownloadSettings && this.equalTo(0, (ImmutableAutoDownloadSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableAutoDownloadSettings another) {
        return this.identifier == another.identifier && this.low.equals(another.low) && this.medium.equals(another.medium) && this.high.equals(another.high);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.low.hashCode();
        h += (h << 5) + this.medium.hashCode();
        h += (h << 5) + this.high.hashCode();
        return h;
    }

    public String toString() {
        return "AutoDownloadSettings{identifier=" + this.identifier + ", low=" + this.low + ", medium=" + this.medium + ", high=" + this.high + "}";
    }

    public static ImmutableAutoDownloadSettings of(AutoDownloadSettings low, AutoDownloadSettings medium, AutoDownloadSettings high) {
        return new ImmutableAutoDownloadSettings(low, medium, high);
    }

    public static ImmutableAutoDownloadSettings copyOf(telegram4j.tl.account.AutoDownloadSettings instance) {
        if (instance instanceof ImmutableAutoDownloadSettings) {
            return (ImmutableAutoDownloadSettings)instance;
        }
        return ImmutableAutoDownloadSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LOW = 1L;
        private static final long INIT_BIT_MEDIUM = 2L;
        private static final long INIT_BIT_HIGH = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private AutoDownloadSettings low;
        private AutoDownloadSettings medium;
        private AutoDownloadSettings high;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.account.AutoDownloadSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.account.AutoDownloadSettings) {
                instance = (telegram4j.tl.account.AutoDownloadSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.high(instance.high());
                this.medium(instance.medium());
                this.low(instance.low());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder low(AutoDownloadSettings low) {
            this.low = Objects.requireNonNull(low, "low");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder medium(AutoDownloadSettings medium) {
            this.medium = Objects.requireNonNull(medium, "medium");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder high(AutoDownloadSettings high) {
            this.high = Objects.requireNonNull(high, "high");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAutoDownloadSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAutoDownloadSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("low");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("medium");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("high");
            }
            return "Cannot build AutoDownloadSettings, some of required attributes are not set " + attributes;
        }
    }
}

