/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.account.BaseSavedRingtones;
import telegram4j.tl.account.SavedRingtones;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseSavedRingtones
implements BaseSavedRingtones {
    private final int identifier;
    private final long hash;
    private final List<Document> ringtones;

    private ImmutableBaseSavedRingtones(long hash) {
        this.hash = hash;
        this.ringtones = Collections.emptyList();
        this.identifier = BaseSavedRingtones.super.identifier();
    }

    private ImmutableBaseSavedRingtones(Builder builder) {
        this.hash = builder.hash;
        this.ringtones = ImmutableBaseSavedRingtones.createUnmodifiableList(true, builder.ringtones);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseSavedRingtones.super.identifier();
    }

    private ImmutableBaseSavedRingtones(int identifier, long hash, List<Document> ringtones) {
        this.identifier = identifier;
        this.hash = hash;
        this.ringtones = ringtones;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<Document> ringtones() {
        return this.ringtones;
    }

    public final ImmutableBaseSavedRingtones withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSavedRingtones(value, this.hash, this.ringtones);
    }

    public final ImmutableBaseSavedRingtones withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseSavedRingtones(this.identifier, value, this.ringtones);
    }

    public final ImmutableBaseSavedRingtones withRingtones(Document ... elements) {
        List<Document> newValue = ImmutableBaseSavedRingtones.createUnmodifiableList(false, ImmutableBaseSavedRingtones.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseSavedRingtones(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseSavedRingtones withRingtones(Iterable<? extends Document> elements) {
        if (this.ringtones == elements) {
            return this;
        }
        List<Document> newValue = ImmutableBaseSavedRingtones.createUnmodifiableList(false, ImmutableBaseSavedRingtones.createSafeList(elements, true, false));
        return new ImmutableBaseSavedRingtones(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSavedRingtones && this.equalTo(0, (ImmutableBaseSavedRingtones)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSavedRingtones another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.ringtones.equals(another.ringtones);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.ringtones.hashCode();
        return h;
    }

    public String toString() {
        return "BaseSavedRingtones{identifier=" + this.identifier + ", hash=" + this.hash + ", ringtones=" + this.ringtones + "}";
    }

    public static ImmutableBaseSavedRingtones of(long hash) {
        return new ImmutableBaseSavedRingtones(hash);
    }

    public static ImmutableBaseSavedRingtones copyOf(BaseSavedRingtones instance) {
        if (instance instanceof ImmutableBaseSavedRingtones) {
            return (ImmutableBaseSavedRingtones)instance;
        }
        return ImmutableBaseSavedRingtones.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<Document> ringtones = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(SavedRingtones instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseSavedRingtones instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SavedRingtones instance;
            long bits = 0L;
            if (object instanceof SavedRingtones) {
                instance = (SavedRingtones)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseSavedRingtones) {
                instance = (BaseSavedRingtones)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllRingtones(instance.ringtones());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRingtone(Document element) {
            this.ringtones.add(Objects.requireNonNull(element, "ringtones element"));
            return this;
        }

        public final Builder addRingtones(Document ... elements) {
            for (Document element : elements) {
                this.ringtones.add(Objects.requireNonNull(element, "ringtones element"));
            }
            return this;
        }

        public final Builder ringtones(Iterable<? extends Document> elements) {
            this.ringtones.clear();
            return this.addAllRingtones(elements);
        }

        public final Builder addAllRingtones(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.ringtones.add(Objects.requireNonNull(document, "ringtones element"));
            }
            return this;
        }

        public ImmutableBaseSavedRingtones build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSavedRingtones(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseSavedRingtones, some of required attributes are not set " + attributes;
        }
    }
}

