/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Theme;
import telegram4j.tl.account.BaseThemes;
import telegram4j.tl.account.Themes;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseThemes
implements BaseThemes {
    private final int identifier;
    private final long hash;
    private final List<Theme> themes;

    private ImmutableBaseThemes(long hash) {
        this.hash = hash;
        this.themes = Collections.emptyList();
        this.identifier = BaseThemes.super.identifier();
    }

    private ImmutableBaseThemes(Builder builder) {
        this.hash = builder.hash;
        this.themes = ImmutableBaseThemes.createUnmodifiableList(true, builder.themes);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseThemes.super.identifier();
    }

    private ImmutableBaseThemes(int identifier, long hash, List<Theme> themes) {
        this.identifier = identifier;
        this.hash = hash;
        this.themes = themes;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<Theme> themes() {
        return this.themes;
    }

    public final ImmutableBaseThemes withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseThemes(value, this.hash, this.themes);
    }

    public final ImmutableBaseThemes withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseThemes(this.identifier, value, this.themes);
    }

    public final ImmutableBaseThemes withThemes(Theme ... elements) {
        List<Theme> newValue = ImmutableBaseThemes.createUnmodifiableList(false, ImmutableBaseThemes.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseThemes(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseThemes withThemes(Iterable<? extends Theme> elements) {
        if (this.themes == elements) {
            return this;
        }
        List<Theme> newValue = ImmutableBaseThemes.createUnmodifiableList(false, ImmutableBaseThemes.createSafeList(elements, true, false));
        return new ImmutableBaseThemes(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseThemes && this.equalTo(0, (ImmutableBaseThemes)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseThemes another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.themes.equals(another.themes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.themes.hashCode();
        return h;
    }

    public String toString() {
        return "BaseThemes{identifier=" + this.identifier + ", hash=" + this.hash + ", themes=" + this.themes + "}";
    }

    public static ImmutableBaseThemes of(long hash) {
        return new ImmutableBaseThemes(hash);
    }

    public static ImmutableBaseThemes copyOf(BaseThemes instance) {
        if (instance instanceof ImmutableBaseThemes) {
            return (ImmutableBaseThemes)instance;
        }
        return ImmutableBaseThemes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<Theme> themes = new ArrayList<Theme>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseThemes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Themes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseThemes) {
                instance = (BaseThemes)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllThemes(instance.themes());
                this.hash(instance.hash());
            }
            if (object instanceof Themes) {
                instance = (Themes)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addTheme(Theme element) {
            this.themes.add(Objects.requireNonNull(element, "themes element"));
            return this;
        }

        public final Builder addThemes(Theme ... elements) {
            for (Theme element : elements) {
                this.themes.add(Objects.requireNonNull(element, "themes element"));
            }
            return this;
        }

        public final Builder themes(Iterable<? extends Theme> elements) {
            this.themes.clear();
            return this.addAllThemes(elements);
        }

        public final Builder addAllThemes(Iterable<? extends Theme> elements) {
            for (Theme theme : elements) {
                this.themes.add(Objects.requireNonNull(theme, "themes element"));
            }
            return this;
        }

        public ImmutableBaseThemes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseThemes(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseThemes, some of required attributes are not set " + attributes;
        }
    }
}

