/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.WallPaper;
import telegram4j.tl.account.BaseWallPapers;
import telegram4j.tl.account.WallPapers;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseWallPapers
implements BaseWallPapers {
    private final int identifier;
    private final long hash;
    private final List<WallPaper> wallpapers;

    private ImmutableBaseWallPapers(long hash) {
        this.hash = hash;
        this.wallpapers = Collections.emptyList();
        this.identifier = BaseWallPapers.super.identifier();
    }

    private ImmutableBaseWallPapers(Builder builder) {
        this.hash = builder.hash;
        this.wallpapers = ImmutableBaseWallPapers.createUnmodifiableList(true, builder.wallpapers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseWallPapers.super.identifier();
    }

    private ImmutableBaseWallPapers(int identifier, long hash, List<WallPaper> wallpapers) {
        this.identifier = identifier;
        this.hash = hash;
        this.wallpapers = wallpapers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<WallPaper> wallpapers() {
        return this.wallpapers;
    }

    public final ImmutableBaseWallPapers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseWallPapers(value, this.hash, this.wallpapers);
    }

    public final ImmutableBaseWallPapers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseWallPapers(this.identifier, value, this.wallpapers);
    }

    public final ImmutableBaseWallPapers withWallpapers(WallPaper ... elements) {
        List<WallPaper> newValue = ImmutableBaseWallPapers.createUnmodifiableList(false, ImmutableBaseWallPapers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseWallPapers(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseWallPapers withWallpapers(Iterable<? extends WallPaper> elements) {
        if (this.wallpapers == elements) {
            return this;
        }
        List<WallPaper> newValue = ImmutableBaseWallPapers.createUnmodifiableList(false, ImmutableBaseWallPapers.createSafeList(elements, true, false));
        return new ImmutableBaseWallPapers(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseWallPapers && this.equalTo(0, (ImmutableBaseWallPapers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseWallPapers another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.wallpapers.equals(another.wallpapers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.wallpapers.hashCode();
        return h;
    }

    public String toString() {
        return "BaseWallPapers{identifier=" + this.identifier + ", hash=" + this.hash + ", wallpapers=" + this.wallpapers + "}";
    }

    public static ImmutableBaseWallPapers of(long hash) {
        return new ImmutableBaseWallPapers(hash);
    }

    public static ImmutableBaseWallPapers copyOf(BaseWallPapers instance) {
        if (instance instanceof ImmutableBaseWallPapers) {
            return (ImmutableBaseWallPapers)instance;
        }
        return ImmutableBaseWallPapers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<WallPaper> wallpapers = new ArrayList<WallPaper>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WallPapers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseWallPapers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WallPapers) {
                instance = (WallPapers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseWallPapers) {
                instance = (BaseWallPapers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllWallpapers(instance.wallpapers());
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addWallpaper(WallPaper element) {
            this.wallpapers.add(Objects.requireNonNull(element, "wallpapers element"));
            return this;
        }

        public final Builder addWallpapers(WallPaper ... elements) {
            for (WallPaper element : elements) {
                this.wallpapers.add(Objects.requireNonNull(element, "wallpapers element"));
            }
            return this;
        }

        public final Builder wallpapers(Iterable<? extends WallPaper> elements) {
            this.wallpapers.clear();
            return this.addAllWallpapers(elements);
        }

        public final Builder addAllWallpapers(Iterable<? extends WallPaper> elements) {
            for (WallPaper wallPaper : elements) {
                this.wallpapers.add(Objects.requireNonNull(wallPaper, "wallpapers element"));
            }
            return this;
        }

        public ImmutableBaseWallPapers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseWallPapers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseWallPapers, some of required attributes are not set " + attributes;
        }
    }
}

