/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.account.ContentSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableContentSettings
implements ContentSettings {
    private final int identifier;
    private final int flags;
    private final boolean sensitiveEnabled;
    private final boolean sensitiveCanChange;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableContentSettings INSTANCE = ImmutableContentSettings.validate(new ImmutableContentSettings());

    private ImmutableContentSettings() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.sensitiveEnabled = this.initShim.sensitiveEnabled();
        this.sensitiveCanChange = this.initShim.sensitiveCanChange();
        this.initShim = null;
    }

    private ImmutableContentSettings(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.sensitiveEnabledIsSet()) {
            this.initShim.sensitiveEnabled(builder.sensitiveEnabled);
        }
        if (builder.sensitiveCanChangeIsSet()) {
            this.initShim.sensitiveCanChange(builder.sensitiveCanChange);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.sensitiveEnabled = this.initShim.sensitiveEnabled();
        this.sensitiveCanChange = this.initShim.sensitiveCanChange();
        this.initShim = null;
    }

    private ImmutableContentSettings(int identifier, int flags, boolean sensitiveEnabled, boolean sensitiveCanChange) {
        this.identifier = identifier;
        this.flags = flags;
        this.sensitiveEnabled = sensitiveEnabled;
        this.sensitiveCanChange = sensitiveCanChange;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ContentSettings.super.identifier();
    }

    private int flagsInitialize() {
        return ContentSettings.super.flags();
    }

    private boolean sensitiveEnabledInitialize() {
        return ContentSettings.super.sensitiveEnabled();
    }

    private boolean sensitiveCanChangeInitialize() {
        return ContentSettings.super.sensitiveCanChange();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean sensitiveEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sensitiveEnabled() : this.sensitiveEnabled;
    }

    @Override
    public boolean sensitiveCanChange() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sensitiveCanChange() : this.sensitiveCanChange;
    }

    public final ImmutableContentSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableContentSettings.validate(new ImmutableContentSettings(value, this.flags, this.sensitiveEnabled, this.sensitiveCanChange));
    }

    public final ImmutableContentSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableContentSettings.validate(new ImmutableContentSettings(this.identifier, value, this.sensitiveEnabled, this.sensitiveCanChange));
    }

    public final ImmutableContentSettings withSensitiveEnabled(boolean value) {
        if (this.sensitiveEnabled == value) {
            return this;
        }
        return ImmutableContentSettings.validate(new ImmutableContentSettings(this.identifier, this.flags, value, this.sensitiveCanChange));
    }

    public final ImmutableContentSettings withSensitiveCanChange(boolean value) {
        if (this.sensitiveCanChange == value) {
            return this;
        }
        return ImmutableContentSettings.validate(new ImmutableContentSettings(this.identifier, this.flags, this.sensitiveEnabled, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentSettings && this.equalTo(0, (ImmutableContentSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.sensitiveEnabled == another.sensitiveEnabled && this.sensitiveCanChange == another.sensitiveCanChange;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.sensitiveEnabled);
        h += (h << 5) + Boolean.hashCode(this.sensitiveCanChange);
        return h;
    }

    public String toString() {
        return "ContentSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", sensitiveEnabled=" + this.sensitiveEnabled + ", sensitiveCanChange=" + this.sensitiveCanChange + "}";
    }

    public static ImmutableContentSettings of() {
        return INSTANCE;
    }

    private static ImmutableContentSettings validate(ImmutableContentSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableContentSettings copyOf(ContentSettings instance) {
        if (instance instanceof ImmutableContentSettings) {
            return (ImmutableContentSettings)instance;
        }
        return ImmutableContentSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SENSITIVE_ENABLED = 4L;
        private static final long OPT_BIT_SENSITIVE_CAN_CHANGE = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean sensitiveEnabled;
        private boolean sensitiveCanChange;

        private Builder() {
        }

        public final Builder from(ContentSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ContentSettings instance;
            long bits = 0L;
            if (object instanceof ContentSettings) {
                instance = (ContentSettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.sensitiveEnabled(instance.sensitiveEnabled());
                this.sensitiveCanChange(instance.sensitiveCanChange());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder sensitiveEnabled(boolean sensitiveEnabled) {
            this.sensitiveEnabled = sensitiveEnabled;
            this.optBits |= 4L;
            return this;
        }

        public final Builder sensitiveCanChange(boolean sensitiveCanChange) {
            this.sensitiveCanChange = sensitiveCanChange;
            this.optBits |= 8L;
            return this;
        }

        public ImmutableContentSettings build() {
            return ImmutableContentSettings.validate(new ImmutableContentSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean sensitiveEnabledIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean sensitiveCanChangeIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte sensitiveEnabledBuildStage = 0;
        private boolean sensitiveEnabled;
        private byte sensitiveCanChangeBuildStage = 0;
        private boolean sensitiveCanChange;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableContentSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableContentSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean sensitiveEnabled() {
            if (this.sensitiveEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sensitiveEnabledBuildStage == 0) {
                this.sensitiveEnabledBuildStage = (byte)-1;
                this.sensitiveEnabled = ImmutableContentSettings.this.sensitiveEnabledInitialize();
                this.sensitiveEnabledBuildStage = 1;
            }
            return this.sensitiveEnabled;
        }

        void sensitiveEnabled(boolean sensitiveEnabled) {
            this.sensitiveEnabled = sensitiveEnabled;
            this.sensitiveEnabledBuildStage = 1;
        }

        boolean sensitiveCanChange() {
            if (this.sensitiveCanChangeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sensitiveCanChangeBuildStage == 0) {
                this.sensitiveCanChangeBuildStage = (byte)-1;
                this.sensitiveCanChange = ImmutableContentSettings.this.sensitiveCanChangeInitialize();
                this.sensitiveCanChangeBuildStage = 1;
            }
            return this.sensitiveCanChange;
        }

        void sensitiveCanChange(boolean sensitiveCanChange) {
            this.sensitiveCanChange = sensitiveCanChange;
            this.sensitiveCanChangeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.sensitiveEnabledBuildStage == -1) {
                attributes.add("sensitiveEnabled");
            }
            if (this.sensitiveCanChangeBuildStage == -1) {
                attributes.add("sensitiveCanChange");
            }
            return "Cannot build ContentSettings, attribute initializers form cycle " + attributes;
        }
    }
}

