/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PasswordKdfAlgo;
import telegram4j.tl.SecurePasswordKdfAlgo;
import telegram4j.tl.account.Password;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePassword
implements Password {
    private final int identifier;
    private final int flags;
    private final boolean hasRecovery;
    private final boolean hasSecureValues;
    private final boolean hasPassword;
    @Nullable
    private final PasswordKdfAlgo currentAlgo;
    private final ByteBuf srpB;
    @Nullable
    private final Long srpId;
    @Nullable
    private final String hint;
    @Nullable
    private final String emailUnconfirmedPattern;
    private final PasswordKdfAlgo newAlgo;
    private final SecurePasswordKdfAlgo newSecureAlgo;
    private final ByteBuf secureRandom;
    @Nullable
    private final Integer pendingResetDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePassword(PasswordKdfAlgo newAlgo, SecurePasswordKdfAlgo newSecureAlgo) {
        this.newAlgo = Objects.requireNonNull(newAlgo, "newAlgo");
        this.newSecureAlgo = Objects.requireNonNull(newSecureAlgo, "newSecureAlgo");
        this.currentAlgo = null;
        this.srpB = null;
        this.srpId = null;
        this.hint = null;
        this.emailUnconfirmedPattern = null;
        this.secureRandom = null;
        this.pendingResetDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasRecovery = this.initShim.hasRecovery();
        this.hasSecureValues = this.initShim.hasSecureValues();
        this.hasPassword = this.initShim.hasPassword();
        this.initShim = null;
    }

    private ImmutablePassword(Builder builder) {
        this.currentAlgo = builder.currentAlgo;
        this.srpB = builder.srpB_build();
        this.srpId = builder.srpId;
        this.hint = builder.hint;
        this.emailUnconfirmedPattern = builder.emailUnconfirmedPattern;
        this.newAlgo = builder.newAlgo;
        this.newSecureAlgo = builder.newSecureAlgo;
        this.secureRandom = builder.secureRandom_build();
        this.pendingResetDate = builder.pendingResetDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.hasRecoveryIsSet()) {
            this.initShim.hasRecovery(builder.hasRecovery);
        }
        if (builder.hasSecureValuesIsSet()) {
            this.initShim.hasSecureValues(builder.hasSecureValues);
        }
        if (builder.hasPasswordIsSet()) {
            this.initShim.hasPassword(builder.hasPassword);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasRecovery = this.initShim.hasRecovery();
        this.hasSecureValues = this.initShim.hasSecureValues();
        this.hasPassword = this.initShim.hasPassword();
        this.initShim = null;
    }

    private ImmutablePassword(int identifier, int flags, boolean hasRecovery, boolean hasSecureValues, boolean hasPassword, @Nullable PasswordKdfAlgo currentAlgo, ByteBuf srpB, @Nullable Long srpId, @Nullable String hint, @Nullable String emailUnconfirmedPattern, PasswordKdfAlgo newAlgo, SecurePasswordKdfAlgo newSecureAlgo, ByteBuf secureRandom, @Nullable Integer pendingResetDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.hasRecovery = hasRecovery;
        this.hasSecureValues = hasSecureValues;
        this.hasPassword = hasPassword;
        this.currentAlgo = currentAlgo;
        this.srpB = srpB;
        this.srpId = srpId;
        this.hint = hint;
        this.emailUnconfirmedPattern = emailUnconfirmedPattern;
        this.newAlgo = newAlgo;
        this.newSecureAlgo = newSecureAlgo;
        this.secureRandom = secureRandom;
        this.pendingResetDate = pendingResetDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Password.super.identifier();
    }

    private int flagsInitialize() {
        return Password.super.flags();
    }

    private boolean hasRecoveryInitialize() {
        return Password.super.hasRecovery();
    }

    private boolean hasSecureValuesInitialize() {
        return Password.super.hasSecureValues();
    }

    private boolean hasPasswordInitialize() {
        return Password.super.hasPassword();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean hasRecovery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRecovery() : this.hasRecovery;
    }

    @Override
    public boolean hasSecureValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasSecureValues() : this.hasSecureValues;
    }

    @Override
    public boolean hasPassword() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasPassword() : this.hasPassword;
    }

    @Override
    @Nullable
    public PasswordKdfAlgo currentAlgo() {
        return this.currentAlgo;
    }

    @Override
    public Optional<ByteBuf> srpB() {
        return Optional.ofNullable(this.srpB).map(ByteBuf::duplicate);
    }

    @Override
    @Nullable
    public Long srpId() {
        return this.srpId;
    }

    @Override
    @Nullable
    public String hint() {
        return this.hint;
    }

    @Override
    @Nullable
    public String emailUnconfirmedPattern() {
        return this.emailUnconfirmedPattern;
    }

    @Override
    public PasswordKdfAlgo newAlgo() {
        return this.newAlgo;
    }

    @Override
    public SecurePasswordKdfAlgo newSecureAlgo() {
        return this.newSecureAlgo;
    }

    @Override
    public ByteBuf secureRandom() {
        return this.secureRandom.duplicate();
    }

    @Override
    @Nullable
    public Integer pendingResetDate() {
        return this.pendingResetDate;
    }

    public final ImmutablePassword withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePassword(value, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePassword(this.identifier, value, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withHasRecovery(boolean value) {
        if (this.hasRecovery == value) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, value, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withHasSecureValues(boolean value) {
        if (this.hasSecureValues == value) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, value, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withHasPassword(boolean value) {
        if (this.hasPassword == value) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, value, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withCurrentAlgo(@Nullable PasswordKdfAlgo value) {
        if (this.currentAlgo == value) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, value, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public ImmutablePassword withSrpB(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.srpB == newValue) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, newValue, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public ImmutablePassword withSrpB(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.srpB == newValue) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, newValue, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withSrpId(@Nullable Long value) {
        if (Objects.equals(this.srpId, value)) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, value, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withHint(@Nullable String value) {
        if (Objects.equals(this.hint, value)) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, value, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withEmailUnconfirmedPattern(@Nullable String value) {
        if (Objects.equals(this.emailUnconfirmedPattern, value)) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, value, this.newAlgo, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withNewAlgo(PasswordKdfAlgo value) {
        if (this.newAlgo == value) {
            return this;
        }
        PasswordKdfAlgo newValue = Objects.requireNonNull(value, "newAlgo");
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, newValue, this.newSecureAlgo, this.secureRandom, this.pendingResetDate);
    }

    public final ImmutablePassword withNewSecureAlgo(SecurePasswordKdfAlgo value) {
        if (this.newSecureAlgo == value) {
            return this;
        }
        SecurePasswordKdfAlgo newValue = Objects.requireNonNull(value, "newSecureAlgo");
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, newValue, this.secureRandom, this.pendingResetDate);
    }

    public ImmutablePassword withSecureRandom(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secureRandom == newValue) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, newValue, this.pendingResetDate);
    }

    public final ImmutablePassword withPendingResetDate(@Nullable Integer value) {
        if (Objects.equals(this.pendingResetDate, value)) {
            return this;
        }
        return new ImmutablePassword(this.identifier, this.flags, this.hasRecovery, this.hasSecureValues, this.hasPassword, this.currentAlgo, this.srpB, this.srpId, this.hint, this.emailUnconfirmedPattern, this.newAlgo, this.newSecureAlgo, this.secureRandom, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePassword && this.equalTo(0, (ImmutablePassword)another);
    }

    private boolean equalTo(int synthetic, ImmutablePassword another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hasRecovery == another.hasRecovery && this.hasSecureValues == another.hasSecureValues && this.hasPassword == another.hasPassword && Objects.equals(this.currentAlgo, another.currentAlgo) && this.srpB().equals(another.srpB()) && Objects.equals(this.srpId, another.srpId) && Objects.equals(this.hint, another.hint) && Objects.equals(this.emailUnconfirmedPattern, another.emailUnconfirmedPattern) && this.newAlgo.equals(another.newAlgo) && this.newSecureAlgo.equals(another.newSecureAlgo) && this.secureRandom().equals((Object)another.secureRandom()) && Objects.equals(this.pendingResetDate, another.pendingResetDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.hasRecovery);
        h += (h << 5) + Boolean.hashCode(this.hasSecureValues);
        h += (h << 5) + Boolean.hashCode(this.hasPassword);
        h += (h << 5) + Objects.hashCode(this.currentAlgo);
        h += (h << 5) + this.srpB().hashCode();
        h += (h << 5) + Objects.hashCode(this.srpId);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + Objects.hashCode(this.emailUnconfirmedPattern);
        h += (h << 5) + this.newAlgo.hashCode();
        h += (h << 5) + this.newSecureAlgo.hashCode();
        h += (h << 5) + this.secureRandom().hashCode();
        h += (h << 5) + Objects.hashCode(this.pendingResetDate);
        return h;
    }

    public String toString() {
        return "Password{identifier=" + this.identifier + ", flags=" + this.flags + ", hasRecovery=" + this.hasRecovery + ", hasSecureValues=" + this.hasSecureValues + ", hasPassword=" + this.hasPassword + ", currentAlgo=" + this.currentAlgo + ", srpB=" + this.srpB().map(ByteBufUtil::hexDump).toString() + ", srpId=" + this.srpId + ", hint=" + this.hint + ", emailUnconfirmedPattern=" + this.emailUnconfirmedPattern + ", newAlgo=" + this.newAlgo + ", newSecureAlgo=" + this.newSecureAlgo + ", secureRandom=" + ByteBufUtil.hexDump((ByteBuf)this.secureRandom) + ", pendingResetDate=" + this.pendingResetDate + "}";
    }

    public static ImmutablePassword of(PasswordKdfAlgo newAlgo, SecurePasswordKdfAlgo newSecureAlgo) {
        return new ImmutablePassword(newAlgo, newSecureAlgo);
    }

    public static ImmutablePassword copyOf(Password instance) {
        if (instance instanceof ImmutablePassword) {
            return (ImmutablePassword)instance;
        }
        return ImmutablePassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NEW_ALGO = 1L;
        private static final long INIT_BIT_NEW_SECURE_ALGO = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HAS_RECOVERY = 4L;
        private static final long OPT_BIT_HAS_SECURE_VALUES = 8L;
        private static final long OPT_BIT_HAS_PASSWORD = 16L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf srpB_value = null;
        private ByteBuf secureRandom_value = null;
        private int identifier;
        private int flags;
        private boolean hasRecovery;
        private boolean hasSecureValues;
        private boolean hasPassword;
        private PasswordKdfAlgo currentAlgo;
        private Long srpId;
        private String hint;
        private String emailUnconfirmedPattern;
        private PasswordKdfAlgo newAlgo;
        private SecurePasswordKdfAlgo newSecureAlgo;
        private Integer pendingResetDate;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Password instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Password) {
                String emailUnconfirmedPatternValue;
                Long srpIdValue;
                PasswordKdfAlgo currentAlgoValue;
                instance = (Password)object;
                this.newAlgo(instance.newAlgo());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((currentAlgoValue = instance.currentAlgo()) != null) {
                    this.currentAlgo(currentAlgoValue);
                }
                if ((srpIdValue = instance.srpId()) != null) {
                    this.srpId(srpIdValue);
                }
                this.srpB(instance.srpB());
                this.flags(instance.flags());
                this.hasPassword(instance.hasPassword());
                this.newSecureAlgo(instance.newSecureAlgo());
                Integer pendingResetDateValue = instance.pendingResetDate();
                if (pendingResetDateValue != null) {
                    this.pendingResetDate(pendingResetDateValue);
                }
                if ((emailUnconfirmedPatternValue = instance.emailUnconfirmedPattern()) != null) {
                    this.emailUnconfirmedPattern(emailUnconfirmedPatternValue);
                }
                this.secureRandom(instance.secureRandom());
                String hintValue = instance.hint();
                if (hintValue != null) {
                    this.hint(hintValue);
                }
                this.hasRecovery(instance.hasRecovery());
                this.hasSecureValues(instance.hasSecureValues());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hasRecovery(boolean hasRecovery) {
            this.hasRecovery = hasRecovery;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hasSecureValues(boolean hasSecureValues) {
            this.hasSecureValues = hasSecureValues;
            this.optBits |= 8L;
            return this;
        }

        public final Builder hasPassword(boolean hasPassword) {
            this.hasPassword = hasPassword;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder currentAlgo(@Nullable PasswordKdfAlgo currentAlgo) {
            this.currentAlgo = currentAlgo;
            return this;
        }

        public Builder srpB(@Nullable ByteBuf value) {
            this.srpB_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder srpB(Optional<ByteBuf> value) {
            this.srpB_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder srpId(@Nullable Long srpId) {
            this.srpId = srpId;
            return this;
        }

        public final Builder hint(@Nullable String hint) {
            this.hint = hint;
            return this;
        }

        public final Builder emailUnconfirmedPattern(@Nullable String emailUnconfirmedPattern) {
            this.emailUnconfirmedPattern = emailUnconfirmedPattern;
            return this;
        }

        public final Builder newAlgo(PasswordKdfAlgo newAlgo) {
            this.newAlgo = Objects.requireNonNull(newAlgo, "newAlgo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder newSecureAlgo(SecurePasswordKdfAlgo newSecureAlgo) {
            this.newSecureAlgo = Objects.requireNonNull(newSecureAlgo, "newSecureAlgo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder secureRandom(ByteBuf value) {
            this.secureRandom_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder pendingResetDate(@Nullable Integer pendingResetDate) {
            this.pendingResetDate = pendingResetDate;
            return this;
        }

        public ImmutablePassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePassword(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hasRecoveryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hasSecureValuesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean hasPasswordIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("newAlgo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newSecureAlgo");
            }
            return "Cannot build Password, some of required attributes are not set " + attributes;
        }

        private ByteBuf srpB_build() {
            return this.srpB_value;
        }

        private ByteBuf secureRandom_build() {
            return Objects.requireNonNull(this.secureRandom_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte hasRecoveryBuildStage = 0;
        private boolean hasRecovery;
        private byte hasSecureValuesBuildStage = 0;
        private boolean hasSecureValues;
        private byte hasPasswordBuildStage = 0;
        private boolean hasPassword;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePassword.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePassword.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean hasRecovery() {
            if (this.hasRecoveryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRecoveryBuildStage == 0) {
                this.hasRecoveryBuildStage = (byte)-1;
                this.hasRecovery = ImmutablePassword.this.hasRecoveryInitialize();
                this.hasRecoveryBuildStage = 1;
            }
            return this.hasRecovery;
        }

        void hasRecovery(boolean hasRecovery) {
            this.hasRecovery = hasRecovery;
            this.hasRecoveryBuildStage = 1;
        }

        boolean hasSecureValues() {
            if (this.hasSecureValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasSecureValuesBuildStage == 0) {
                this.hasSecureValuesBuildStage = (byte)-1;
                this.hasSecureValues = ImmutablePassword.this.hasSecureValuesInitialize();
                this.hasSecureValuesBuildStage = 1;
            }
            return this.hasSecureValues;
        }

        void hasSecureValues(boolean hasSecureValues) {
            this.hasSecureValues = hasSecureValues;
            this.hasSecureValuesBuildStage = 1;
        }

        boolean hasPassword() {
            if (this.hasPasswordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasPasswordBuildStage == 0) {
                this.hasPasswordBuildStage = (byte)-1;
                this.hasPassword = ImmutablePassword.this.hasPasswordInitialize();
                this.hasPasswordBuildStage = 1;
            }
            return this.hasPassword;
        }

        void hasPassword(boolean hasPassword) {
            this.hasPassword = hasPassword;
            this.hasPasswordBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.hasRecoveryBuildStage == -1) {
                attributes.add("hasRecovery");
            }
            if (this.hasSecureValuesBuildStage == -1) {
                attributes.add("hasSecureValues");
            }
            if (this.hasPasswordBuildStage == -1) {
                attributes.add("hasPassword");
            }
            return "Cannot build Password, attribute initializers form cycle " + attributes;
        }
    }
}

