/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PasswordKdfAlgo;
import telegram4j.tl.SecureSecretSettings;
import telegram4j.tl.account.PasswordInputSettings;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutablePasswordInputSettings
implements PasswordInputSettings {
    private final int identifier;
    private final int flags;
    @Nullable
    private final PasswordKdfAlgo newAlgo;
    private final ByteBuf newPasswordHash;
    @Nullable
    private final String hint;
    @Nullable
    private final String email;
    @Nullable
    private final SecureSecretSettings newSecureSettings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePasswordInputSettings INSTANCE = ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings());

    private ImmutablePasswordInputSettings() {
        this.newAlgo = null;
        this.newPasswordHash = null;
        this.hint = null;
        this.email = null;
        this.newSecureSettings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePasswordInputSettings(Builder builder) {
        this.newAlgo = builder.newAlgo;
        this.newPasswordHash = builder.newPasswordHash_build();
        this.hint = builder.hint;
        this.email = builder.email;
        this.newSecureSettings = builder.newSecureSettings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePasswordInputSettings(int identifier, int flags, @Nullable PasswordKdfAlgo newAlgo, ByteBuf newPasswordHash, @Nullable String hint, @Nullable String email, @Nullable SecureSecretSettings newSecureSettings) {
        this.identifier = identifier;
        this.flags = flags;
        this.newAlgo = newAlgo;
        this.newPasswordHash = newPasswordHash;
        this.hint = hint;
        this.email = email;
        this.newSecureSettings = newSecureSettings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PasswordInputSettings.super.identifier();
    }

    private int flagsInitialize() {
        return PasswordInputSettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public PasswordKdfAlgo newAlgo() {
        return this.newAlgo;
    }

    @Override
    public Optional<ByteBuf> newPasswordHash() {
        return Optional.ofNullable(this.newPasswordHash).map(ByteBuf::duplicate);
    }

    @Override
    @Nullable
    public String hint() {
        return this.hint;
    }

    @Override
    @Nullable
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public SecureSecretSettings newSecureSettings() {
        return this.newSecureSettings;
    }

    public final ImmutablePasswordInputSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(value, this.flags, this.newAlgo, this.newPasswordHash, this.hint, this.email, this.newSecureSettings));
    }

    public final ImmutablePasswordInputSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, value, this.newAlgo, this.newPasswordHash, this.hint, this.email, this.newSecureSettings));
    }

    public final ImmutablePasswordInputSettings withNewAlgo(@Nullable PasswordKdfAlgo value) {
        if (this.newAlgo == value) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, value, this.newPasswordHash, this.hint, this.email, this.newSecureSettings));
    }

    public ImmutablePasswordInputSettings withNewPasswordHash(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.newPasswordHash == newValue) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, this.newAlgo, newValue, this.hint, this.email, this.newSecureSettings));
    }

    public ImmutablePasswordInputSettings withNewPasswordHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.newPasswordHash == newValue) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, this.newAlgo, newValue, this.hint, this.email, this.newSecureSettings));
    }

    public final ImmutablePasswordInputSettings withHint(@Nullable String value) {
        if (Objects.equals(this.hint, value)) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, this.newAlgo, this.newPasswordHash, value, this.email, this.newSecureSettings));
    }

    public final ImmutablePasswordInputSettings withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, this.newAlgo, this.newPasswordHash, this.hint, value, this.newSecureSettings));
    }

    public final ImmutablePasswordInputSettings withNewSecureSettings(@Nullable SecureSecretSettings value) {
        if (this.newSecureSettings == value) {
            return this;
        }
        return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this.identifier, this.flags, this.newAlgo, this.newPasswordHash, this.hint, this.email, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordInputSettings && this.equalTo(0, (ImmutablePasswordInputSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordInputSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.newAlgo, another.newAlgo) && this.newPasswordHash().equals(another.newPasswordHash()) && Objects.equals(this.hint, another.hint) && Objects.equals(this.email, another.email) && Objects.equals(this.newSecureSettings, another.newSecureSettings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.newAlgo);
        h += (h << 5) + this.newPasswordHash().hashCode();
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.newSecureSettings);
        return h;
    }

    public String toString() {
        return "PasswordInputSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", newAlgo=" + this.newAlgo + ", newPasswordHash=" + this.newPasswordHash().map(ByteBufUtil::hexDump).toString() + ", hint=" + this.hint + ", email=" + this.email + ", newSecureSettings=" + this.newSecureSettings + "}";
    }

    public static ImmutablePasswordInputSettings of() {
        return INSTANCE;
    }

    private static ImmutablePasswordInputSettings validate(ImmutablePasswordInputSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePasswordInputSettings copyOf(PasswordInputSettings instance) {
        if (instance instanceof ImmutablePasswordInputSettings) {
            return (ImmutablePasswordInputSettings)instance;
        }
        return ImmutablePasswordInputSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private ByteBuf newPasswordHash_value = null;
        private int identifier;
        private int flags;
        private PasswordKdfAlgo newAlgo;
        private String hint;
        private String email;
        private SecureSecretSettings newSecureSettings;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PasswordInputSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PasswordInputSettings) {
                String hintValue;
                SecureSecretSettings newSecureSettingsValue;
                instance = (PasswordInputSettings)object;
                PasswordKdfAlgo newAlgoValue = instance.newAlgo();
                if (newAlgoValue != null) {
                    this.newAlgo(newAlgoValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((newSecureSettingsValue = instance.newSecureSettings()) != null) {
                    this.newSecureSettings(newSecureSettingsValue);
                }
                if ((hintValue = instance.hint()) != null) {
                    this.hint(hintValue);
                }
                this.flags(instance.flags());
                this.newPasswordHash(instance.newPasswordHash());
                String emailValue = instance.email();
                if (emailValue != null) {
                    this.email(emailValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder newAlgo(@Nullable PasswordKdfAlgo newAlgo) {
            this.newAlgo = newAlgo;
            return this;
        }

        public Builder newPasswordHash(@Nullable ByteBuf value) {
            this.newPasswordHash_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder newPasswordHash(Optional<ByteBuf> value) {
            this.newPasswordHash_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder hint(@Nullable String hint) {
            this.hint = hint;
            return this;
        }

        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        public final Builder newSecureSettings(@Nullable SecureSecretSettings newSecureSettings) {
            this.newSecureSettings = newSecureSettings;
            return this;
        }

        public ImmutablePasswordInputSettings build() {
            return ImmutablePasswordInputSettings.validate(new ImmutablePasswordInputSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private ByteBuf newPasswordHash_build() {
            return this.newPasswordHash_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePasswordInputSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePasswordInputSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PasswordInputSettings, attribute initializers form cycle " + attributes;
        }
    }
}

