/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.SecureSecretSettings;
import telegram4j.tl.account.PasswordSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutablePasswordSettings
implements PasswordSettings {
    private final int identifier;
    private final int flags;
    @Nullable
    private final String email;
    @Nullable
    private final SecureSecretSettings secureSettings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutablePasswordSettings INSTANCE = ImmutablePasswordSettings.validate(new ImmutablePasswordSettings());

    private ImmutablePasswordSettings() {
        this.email = null;
        this.secureSettings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePasswordSettings(Builder builder) {
        this.email = builder.email;
        this.secureSettings = builder.secureSettings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePasswordSettings(int identifier, int flags, @Nullable String email, @Nullable SecureSecretSettings secureSettings) {
        this.identifier = identifier;
        this.flags = flags;
        this.email = email;
        this.secureSettings = secureSettings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PasswordSettings.super.identifier();
    }

    private int flagsInitialize() {
        return PasswordSettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public String email() {
        return this.email;
    }

    @Override
    @Nullable
    public SecureSecretSettings secureSettings() {
        return this.secureSettings;
    }

    public final ImmutablePasswordSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutablePasswordSettings.validate(new ImmutablePasswordSettings(value, this.flags, this.email, this.secureSettings));
    }

    public final ImmutablePasswordSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutablePasswordSettings.validate(new ImmutablePasswordSettings(this.identifier, value, this.email, this.secureSettings));
    }

    public final ImmutablePasswordSettings withEmail(@Nullable String value) {
        if (Objects.equals(this.email, value)) {
            return this;
        }
        return ImmutablePasswordSettings.validate(new ImmutablePasswordSettings(this.identifier, this.flags, value, this.secureSettings));
    }

    public final ImmutablePasswordSettings withSecureSettings(@Nullable SecureSecretSettings value) {
        if (this.secureSettings == value) {
            return this;
        }
        return ImmutablePasswordSettings.validate(new ImmutablePasswordSettings(this.identifier, this.flags, this.email, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordSettings && this.equalTo(0, (ImmutablePasswordSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.email, another.email) && Objects.equals(this.secureSettings, another.secureSettings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.email);
        h += (h << 5) + Objects.hashCode(this.secureSettings);
        return h;
    }

    public String toString() {
        return "PasswordSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", email=" + this.email + ", secureSettings=" + this.secureSettings + "}";
    }

    public static ImmutablePasswordSettings of() {
        return INSTANCE;
    }

    private static ImmutablePasswordSettings validate(ImmutablePasswordSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutablePasswordSettings copyOf(PasswordSettings instance) {
        if (instance instanceof ImmutablePasswordSettings) {
            return (ImmutablePasswordSettings)instance;
        }
        return ImmutablePasswordSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private String email;
        private SecureSecretSettings secureSettings;

        private Builder() {
        }

        public final Builder from(PasswordSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PasswordSettings instance;
            long bits = 0L;
            if (object instanceof PasswordSettings) {
                SecureSecretSettings secureSettingsValue;
                String emailValue;
                instance = (PasswordSettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((emailValue = instance.email()) != null) {
                    this.email(emailValue);
                }
                if ((secureSettingsValue = instance.secureSettings()) != null) {
                    this.secureSettings(secureSettingsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        public final Builder secureSettings(@Nullable SecureSecretSettings secureSettings) {
            this.secureSettings = secureSettings;
            return this;
        }

        public ImmutablePasswordSettings build() {
            return ImmutablePasswordSettings.validate(new ImmutablePasswordSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePasswordSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePasswordSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PasswordSettings, attribute initializers form cycle " + attributes;
        }
    }
}

